/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Handler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.FlushingHandlerUpdateProperties;
import org.jboss.as.logging.LoggingSubsystemParser;
import org.jboss.as.logging.SizeRotatingFileHandlerAdd;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.SizeRotatingFileHandler;

public class SizeRotatingHandlerUpdateProperties
extends FlushingHandlerUpdateProperties {
    static final SizeRotatingHandlerUpdateProperties INSTANCE = new SizeRotatingHandlerUpdateProperties();

    @Override
    protected void updateModel(ModelNode operation, ModelNode model) {
        super.updateModel(operation, model);
        if (operation.hasDefined("max-backup-index")) {
            this.apply(operation, model, "max-backup-index");
        }
        if (operation.hasDefined("rotate-size")) {
            this.apply(operation, model, "rotate-size");
        }
    }

    @Override
    protected void updateRuntime(ModelNode operation, Handler handler) throws OperationFailedException {
        super.updateRuntime(operation, handler);
        if (operation.hasDefined("max-backup-index")) {
            ((SizeRotatingFileHandler)SizeRotatingFileHandler.class.cast(handler)).setMaxBackupIndex(operation.get("max-backup-index").asInt());
        }
        if (operation.hasDefined("rotate-size")) {
            long rotateSize = SizeRotatingFileHandlerAdd.DEFAULT_ROTATE_SIZE;
            try {
                rotateSize = LoggingSubsystemParser.parseSize(operation.get("rotate-size").asString());
            }
            catch (Throwable t) {
                throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
            }
            ((SizeRotatingFileHandler)SizeRotatingFileHandler.class.cast(handler)).setRotateSize(rotateSize);
        }
    }
}

