/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LoggingDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    static final LoggingDescribeHandler INSTANCE = new LoggingDescribeHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        PathAddress rootAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathAddress.pathAddress((ModelNode)operation.require("address")).getLastElement()});
        ModelNode result = context.getResult();
        result.add(LoggingExtension.NewLoggingSubsystemAdd.createOperation(rootAddress.toModelNode()));
        if (model.hasDefined("root-logger")) {
            ModelNode add = Util.getEmptyOperation((String)"set-root-logger", (ModelNode)rootAddress.toModelNode());
            add.get("level").set(model.get(new String[]{"root-logger", "level"}));
            add.get("handlers").set(model.get(new String[]{"root-logger", "handlers"}));
            result.add(add);
        }
        if (model.hasDefined("logger")) {
            for (Property prop : model.get("logger").asPropertyList()) {
                ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"logger", (String)prop.getName())}).toModelNode());
                add.get("handlers").set(prop.getValue().get("handlers"));
                add.get("level").set(prop.getValue().get("level"));
                result.add(add);
            }
        }
        if (model.hasDefined("async-handler")) {
            for (Property prop : model.get("async-handler").asPropertyList()) {
                result.add(this.defineAsynchHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("console-handler")) {
            for (Property prop : model.get("console-handler").asPropertyList()) {
                result.add(this.defineConsoleHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("file-handler")) {
            for (Property prop : model.get("file-handler").asPropertyList()) {
                result.add(this.defineFileHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("custom-handler")) {
            for (Property prop : model.get("custom-handler").asPropertyList()) {
                result.add(this.defineCustomHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("periodic-rotating-file-handler")) {
            for (Property prop : model.get("periodic-rotating-file-handler").asPropertyList()) {
                result.add(this.definePeriodicRotatingFileHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        if (model.hasDefined("size-rotating-file-handler")) {
            for (Property prop : model.get("size-rotating-file-handler").asPropertyList()) {
                result.add(this.defineSizeRotatingFileHandler(prop.getName(), prop.getValue(), rootAddress));
            }
        }
        context.completeStep();
    }

    private ModelNode defineAsynchHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"async-handler", (String)name)}).toModelNode());
        add.get("queue-length").set(handler.get("queue-length"));
        add.get("subhandlers").set(handler.get("subhandlers"));
        add.get("level").set(handler.get("level"));
        add.get("overflow-action").set(handler.get("overflow-action"));
        return add;
    }

    private ModelNode defineConsoleHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"console-handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("queue-length")) {
            add.get("queue-length").set(handler.get("queue-length"));
        }
        return add;
    }

    private ModelNode defineFileHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"file-handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("file")) {
            add.get("file").set(handler.get("file"));
        }
        if (handler.hasDefined("queue-length")) {
            add.get("queue-length").set(handler.get("queue-length"));
        }
        return add;
    }

    private ModelNode defineCustomHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"custom-handler", (String)name)}).toModelNode());
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("queue-length")) {
            add.get("queue-length").set(handler.get("queue-length"));
        }
        if (handler.hasDefined("class")) {
            add.get("class").set(handler.get("class"));
        }
        if (handler.hasDefined("module")) {
            add.get("module").set(handler.get("module"));
        }
        if (handler.hasDefined("properties")) {
            add.get("properties").set(handler.get("properties"));
        }
        return add;
    }

    private ModelNode definePeriodicRotatingFileHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"periodic-rotating-file-handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("file")) {
            add.get("file").set(handler.get("file"));
        }
        if (handler.hasDefined("queue-length")) {
            add.get("queue-length").set(handler.get("queue-length"));
        }
        if (handler.hasDefined("suffix")) {
            add.get("suffix").set(handler.get("suffix"));
        }
        return add;
    }

    private ModelNode defineSizeRotatingFileHandler(String name, ModelNode handler, PathAddress rootAddress) {
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)rootAddress.append(new PathElement[]{PathElement.pathElement((String)"size-rotating-file-handler", (String)name)}).toModelNode());
        if (handler.hasDefined("autoflush")) {
            add.get("autoflush").set(handler.get("autoflush"));
        }
        if (handler.hasDefined("encoding")) {
            add.get("encoding").set(handler.get("encoding"));
        }
        if (handler.hasDefined("formatter")) {
            add.get("formatter").set(handler.get("formatter"));
        }
        if (handler.hasDefined("level")) {
            add.get("level").set(handler.get("level"));
        }
        if (handler.hasDefined("file")) {
            add.get("file").set(handler.get("file"));
        }
        if (handler.hasDefined("max-backup-index")) {
            add.get("max-backup-index").set(handler.get("max-backup-index"));
        }
        if (handler.hasDefined("rotate-size")) {
            add.get("rotate-size").set(handler.get("rotate-size"));
        }
        return add;
    }

    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getSubsystemDescribeOperation((Locale)locale);
    }
}

