/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Level;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggerService;
import org.jboss.as.logging.LoggingValidators;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class LoggerAdd
extends AbstractAddStepHandler {
    static final LoggerAdd INSTANCE = new LoggerAdd();

    LoggerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode handlers;
        LoggingValidators.validate(operation);
        String level = operation.require("level").asString();
        ModelNode modelNode = handlers = operation.hasDefined("handlers") ? operation.get("handlers") : new ModelNode();
        if (operation.hasDefined("level")) {
            model.get("level").set(level);
        }
        model.get("handlers").set(handlers);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String level = operation.require("level").asString();
        ModelNode handlers = operation.hasDefined("handlers") ? operation.get("handlers") : new ModelNode();
        ServiceTarget target = context.getServiceTarget();
        String loggerName = name;
        try {
            LoggerService service = new LoggerService(loggerName);
            if (operation.hasDefined("level")) {
                service.setLevel(Level.parse(level));
            }
            newControllers.add(target.addService(LogServices.loggerName(loggerName), (Service)service).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install());
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
        try {
            if (handlers.isDefined()) {
                newControllers.addAll(LogServices.installLoggerHandlers(target, loggerName, handlers, verificationHandler));
            }
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
    }
}

