/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.logging.Level;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

final class LogLevelValidator
implements ParameterValidator {
    LogLevelValidator() {
    }

    public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
        if (value.isDefined() && value.getType() != ModelType.EXPRESSION) {
            String level = value.asString();
            try {
                Level.parse(level);
            }
            catch (IllegalArgumentException e) {
                throw new OperationFailedException(new ModelNode().set(String.format("Log level %s is invalid.", level)));
            }
        }
    }

    public void validateResolvedParameter(String parameterName, ModelNode value) throws OperationFailedException {
        this.validateParameter(parameterName, value.resolve());
    }
}

