/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.io.UnsupportedEncodingException;
import java.util.logging.Handler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingValidators;
import org.jboss.as.logging.PatternFormatterSpec;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Level;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public abstract class HandlerUpdateProperties
implements OperationStepHandler {
    static final String OPERATION_NAME = "update-properties";

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        ModelNode model = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS);
        if (operation.hasDefined("level")) {
            this.apply(operation, model, "level");
        }
        if (operation.hasDefined("formatter")) {
            this.apply(operation, model, "formatter");
        }
        if (operation.hasDefined("encoding")) {
            this.apply(operation, model, "encoding");
        }
        this.updateModel(operation, model);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    LoggingValidators.validate(operation);
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
                    if (controller != null) {
                        Handler handler = (Handler)controller.getValue();
                        if (operation.hasDefined("level")) {
                            handler.setLevel(Level.parse((String)operation.get("level").asString()));
                        }
                        if (operation.hasDefined("formatter")) {
                            new PatternFormatterSpec(operation.get("formatter").asString()).apply(handler);
                        }
                        if (operation.hasDefined("encoding")) {
                            try {
                                handler.setEncoding(operation.get("encoding").asString());
                            }
                            catch (UnsupportedEncodingException e) {
                                throw new OperationFailedException((Throwable)e, new ModelNode().set("Failed to set handler encoding."));
                            }
                        }
                        HandlerUpdateProperties.this.updateRuntime(operation, handler);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected abstract void updateModel(ModelNode var1, ModelNode var2);

    protected abstract void updateRuntime(ModelNode var1, Handler var2) throws OperationFailedException;

    protected void apply(ModelNode from, ModelNode to, String ... attributePath) {
        if (from.get(attributePath).isDefined()) {
            to.get(attributePath).set(from.get(attributePath));
        }
    }
}

