/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.HandlerFileService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class HandlerFileChange
implements OperationStepHandler {
    static final String OPERATION_NAME = "change-file";
    static final HandlerFileChange INSTANCE = new HandlerFileChange();

    public void execute(OperationContext context, ModelNode operation) {
        ModelNode existingFile = context.readModelForUpdate(PathAddress.EMPTY_ADDRESS).get("file");
        existingFile.get("path").set(operation.get("path"));
        if (existingFile.hasDefined("relative-to")) {
            existingFile.get("relative-to").set(operation.get("relative-to"));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        final String name = address.getLastElement().getValue();
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(final OperationContext context, final ModelNode operation) {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                    final ServiceTarget serviceTarget = context.getServiceTarget();
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerFileName(name));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<?> controller) {
                                controller.setMode(ServiceController.Mode.REMOVE);
                            }

                            public void serviceRemoved(ServiceController<?> controller) {
                                HandlerFileChange.this.installService(context, operation, serviceTarget, name);
                            }
                        });
                    } else {
                        HandlerFileChange.this.installService(context, operation, serviceTarget, name);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    private void installService(OperationContext context, ModelNode operation, ServiceTarget serviceTarget, String name) {
        ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
        HandlerFileService service = new HandlerFileService(operation.get("path").asString());
        ServiceBuilder builder = serviceTarget.addService(LogServices.handlerFileName(name), (Service)service);
        if (operation.hasDefined("relative-to")) {
            builder.addDependency(AbstractPathService.pathNameOf((String)operation.get("relative-to").asString()), String.class, service.getRelativeToInjector());
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
        context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
            context.removeService(LogServices.handlerFileName(name));
        }
    }
}

