/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceRegistry;

public class HandlerDisable
implements OperationStepHandler {
    static final HandlerDisable INSTANCE = new HandlerDisable();

    public void execute(OperationContext context, ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        final String name = address.getLastElement().getValue();
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(final OperationContext context, ModelNode operation) {
                    ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
                    ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
                    if (controller != null) {
                        controller.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                            public void listenerAdded(ServiceController<?> serviceController) {
                                serviceController.setMode(ServiceController.Mode.NEVER);
                            }

                            public void serviceStopped(ServiceController<?> serviceController) {
                                context.completeStep();
                            }
                        });
                    } else {
                        context.completeStep();
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }
}

