/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.logging.Level;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.AbstractFormatterSpec;
import org.jboss.as.logging.ConsoleHandlerService;
import org.jboss.as.logging.LogServices;
import org.jboss.as.logging.LoggingValidators;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

class ConsoleHandlerAdd
extends AbstractAddStepHandler {
    static final ConsoleHandlerAdd INSTANCE = new ConsoleHandlerAdd();

    ConsoleHandlerAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        LoggingValidators.validate(operation);
        model.get("autoflush").set(operation.get("autoflush"));
        model.get("encoding").set(operation.get("encoding"));
        model.get("formatter").set(operation.get("formatter"));
        if (operation.hasDefined("level")) {
            model.get("level").set(operation.get("level"));
        }
        model.get("queue-length").set(operation.get("queue-length"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        Boolean autoFlush;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        ServiceTarget serviceTarget = context.getServiceTarget();
        ConsoleHandlerService service = new ConsoleHandlerService();
        ServiceBuilder serviceBuilder = serviceTarget.addService(LogServices.handlerName(name), (Service)service);
        if (operation.hasDefined("level")) {
            service.setLevel(Level.parse(operation.get("level").asString()));
        }
        if ((autoFlush = Boolean.valueOf(operation.get("autoflush").asBoolean())) != null) {
            service.setAutoflush(autoFlush);
        }
        try {
            if (operation.hasDefined("encoding")) {
                service.setEncoding(operation.get("encoding").asString());
            }
        }
        catch (Throwable t) {
            throw new OperationFailedException(new ModelNode().set(t.getLocalizedMessage()));
        }
        service.setFormatterSpec(AbstractFormatterSpec.Factory.create(operation));
        serviceBuilder.addListener((ServiceListener)verificationHandler);
        serviceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(serviceBuilder.install());
    }
}

