/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.jboss.as.logging.OverflowAction;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public final class AsyncHandlerService
implements Service<Handler> {
    private final List<InjectedValue<Handler>> subhandlers = new ArrayList<InjectedValue<Handler>>();
    private OverflowAction overflowAction;
    private int queueLength;
    private AsyncHandler value;
    private Level level;

    public synchronized void start(StartContext context) throws StartException {
        AsyncHandler handler;
        this.value = handler = new AsyncHandler(this.queueLength);
        OverflowAction action = this.overflowAction;
        AsyncHandlerService.setAction(handler, action);
        Handler[] handlers = new Handler[this.subhandlers.size()];
        int subhandlersSize = this.subhandlers.size();
        for (int i = 0; i < subhandlersSize; ++i) {
            handlers[i] = (Handler)this.subhandlers.get(i).getValue();
        }
        handler.setHandlers(handlers);
        if (this.level != null) {
            handler.setLevel(this.level);
        }
    }

    private static void setAction(AsyncHandler handler, OverflowAction action) {
        if (handler == null) {
            return;
        }
        switch (action) {
            case BLOCK: {
                handler.setOverflowAction(AsyncHandler.OverflowAction.BLOCK);
                break;
            }
            case DISCARD: {
                handler.setOverflowAction(AsyncHandler.OverflowAction.DISCARD);
            }
        }
    }

    public synchronized void stop(StopContext context) {
        AsyncHandler handler = this.value;
        handler.close();
        handler.setLevel(Level.OFF);
        handler.clearHandlers();
        this.value = null;
    }

    public synchronized Handler getValue() throws IllegalStateException {
        return this.value;
    }

    public synchronized void setOverflowAction(OverflowAction overflowAction) {
        this.overflowAction = overflowAction;
        AsyncHandlerService.setAction(this.value, overflowAction);
    }

    public synchronized void setQueueLength(int queueLength) {
        this.queueLength = queueLength;
    }

    public synchronized void setLevel(Level level) {
        this.level = level;
        AsyncHandler handler = this.value;
        if (handler != null) {
            handler.setLevel(level);
        }
    }

    public synchronized void addHandlers(List<InjectedValue<Handler>> list) {
        this.subhandlers.addAll(list);
    }

    public synchronized void addHandler(InjectedValue<Handler> injectedHandler) {
        this.subhandlers.add(injectedHandler);
        AsyncHandler handler = this.value;
        handler.addHandler((Handler)injectedHandler.getValue());
    }

    public synchronized void removeHandler(Handler subHandler) {
        InjectedValue<Handler> valueToRemove = null;
        for (InjectedValue<Handler> injectedHandler : this.subhandlers) {
            if (!((Handler)injectedHandler.getValue()).equals(subHandler)) continue;
            valueToRemove = injectedHandler;
        }
        this.subhandlers.remove(valueToRemove);
        AsyncHandler handler = this.value;
        handler.removeHandler((Handler)valueToRemove.getValue());
    }
}

