/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

abstract class AbstractWriteAttributeHandler
extends ServerWriteAttributeOperationHandler {
    AbstractWriteAttributeHandler(ParameterValidator valueValidator, ParameterValidator resolvedValueValidator) {
        super(valueValidator, resolvedValueValidator);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, final ModelNode newValue, final ModelNode currentValue) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String name = address.getLastElement().getValue();
                    ServiceController controller = context.getServiceRegistry(false).getService(DeploymentScannerService.getServiceName(name));
                    DeploymentScanner scanner = null;
                    if (controller == null) {
                        throw new OperationFailedException(new ModelNode().set("scanner not configured"));
                    }
                    scanner = (DeploymentScanner)controller.getValue();
                    AbstractWriteAttributeHandler.this.updateScanner(scanner, newValue);
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK && scanner != null) {
                        AbstractWriteAttributeHandler.this.updateScanner(scanner, currentValue);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        return false;
    }

    protected abstract void updateScanner(DeploymentScanner var1, ModelNode var2);
}

