/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.infinispan.util.AbstractMap;
import org.infinispan.util.BidirectionalMap;
import org.infinispan.util.ReversibleOrderedSet;

public class InfinispanCollections {
    private static final ReversibleOrderedSet EMPTY_ROS = new EmptyReversibleOrderedSet();
    public static final BidirectionalMap EMPTY_BIDI_MAP = new EmptyBidiMap();

    public static <T> ReversibleOrderedSet<T> emptyReversibleOrderedSet() {
        return EMPTY_ROS;
    }

    public static <K, V> BidirectionalMap<K, V> emptyBidirectionalMap() {
        return EMPTY_BIDI_MAP;
    }

    public static <K, V, E> Map<K, V> transformMapValue(Map<K, E> input, Function<E, V> f) {
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        if (input.size() == 1) {
            Map.Entry<K, E> single = input.entrySet().iterator().next();
            return Collections.singletonMap(single.getKey(), f.transform(single.getValue()));
        }
        HashMap<K, V> copy = new HashMap<K, V>(input.size());
        for (Map.Entry<K, E> entry : input.entrySet()) {
            copy.put(entry.getKey(), f.transform(entry.getValue()));
        }
        return Collections.unmodifiableMap(copy);
    }

    public static <K, V, E> Map<K, V> transformCollectionToMap(Collection<E> input, MapMakerFunction<K, V, E> f) {
        if (input.isEmpty()) {
            return Collections.emptyMap();
        }
        if (input.size() == 1) {
            E single = input.iterator().next();
            Map.Entry<K, V> entry = f.transform(single);
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        HashMap<K, V> map = new HashMap<K, V>(input.size());
        for (E e : input) {
            Map.Entry<K, V> entry = f.transform(e);
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    public static interface MapMakerFunction<K, V, E> {
        public Map.Entry<K, V> transform(E var1);
    }

    public static interface Function<E, T> {
        public T transform(E var1);
    }

    private static final class EmptyBidiMap
    extends AbstractMap
    implements BidirectionalMap {
        private EmptyBidiMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Object get(Object key) {
            return null;
        }

        @Override
        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public ReversibleOrderedSet keySet() {
            return EMPTY_ROS;
        }

        @Override
        public Collection values() {
            return Collections.emptySet();
        }

        public ReversibleOrderedSet entrySet() {
            return EMPTY_ROS;
        }
    }

    private static final class EmptyReversibleOrderedSet
    extends AbstractSet
    implements ReversibleOrderedSet {
        Iterator it = new Iterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };

        private EmptyReversibleOrderedSet() {
        }

        @Override
        public Iterator iterator() {
            return this.it;
        }

        @Override
        public int size() {
            return 0;
        }

        public Iterator reverseIterator() {
            return this.it;
        }
    }
}

