/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.remoting.transport.DistributedSync;
import org.infinispan.util.Util;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.concurrent.ReclosableLatch;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class JGroupsDistSync
implements DistributedSync {
    private final ReentrantReadWriteLock processingLock = new ReentrantReadWriteLock();
    private final ReclosableLatch flushBlockGate = new ReclosableLatch(true);
    private final AtomicInteger flushBlockGateCount = new AtomicInteger(0);
    private final AtomicInteger flushWaitGateCount = new AtomicInteger(0);
    private final ReclosableLatch flushWaitGate = new ReclosableLatch(false);
    private static final Log log = LogFactory.getLog(JGroupsDistSync.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ConcurrentHashSet<Thread> debugReadLockHolders = new ConcurrentHashSet();

    @Override
    public DistributedSync.SyncResponse blockUntilAcquired(long timeout, TimeUnit timeUnit) throws TimeoutException {
        int initState = this.flushWaitGateCount.get();
        try {
            if (!this.flushWaitGate.await(timeout, timeUnit)) {
                throw new TimeoutException("Timed out waiting for a cluster-wide sync to be acquired. (timeout = " + Util.prettyPrintTime(timeout) + ")");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return initState == this.flushWaitGateCount.get() ? DistributedSync.SyncResponse.STATE_PREEXISTED : DistributedSync.SyncResponse.STATE_ACHIEVED;
    }

    @Override
    public DistributedSync.SyncResponse blockUntilReleased(long timeout, TimeUnit timeUnit) throws TimeoutException {
        int initState = this.flushBlockGateCount.get();
        try {
            if (!this.flushBlockGate.await(timeout, timeUnit)) {
                throw new TimeoutException("Timed out waiting for a cluster-wide sync to be released. (timeout = " + Util.prettyPrintTime(timeout) + ")");
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        return initState == this.flushWaitGateCount.get() ? DistributedSync.SyncResponse.STATE_PREEXISTED : DistributedSync.SyncResponse.STATE_ACHIEVED;
    }

    @Override
    public void acquireSync() {
        this.flushBlockGate.close();
        this.flushWaitGateCount.incrementAndGet();
        this.flushWaitGate.open();
    }

    @Override
    public void releaseSync() {
        this.flushWaitGate.close();
        this.flushBlockGateCount.incrementAndGet();
        this.flushBlockGate.open();
    }

    @Override
    public void acquireProcessingLock(boolean exclusive, long timeout, TimeUnit timeUnit) throws TimeoutException {
        Lock lock = exclusive ? this.processingLock.writeLock() : this.processingLock.readLock();
        try {
            if (!lock.tryLock(timeout, timeUnit)) {
                if (exclusive) {
                    log.debugf("Failed to acquire exclusive processing lock. Read lock holders are %s", this.debugReadLockHolders);
                }
                throw new TimeoutException(String.format("%s could not obtain %s processing lock after %s.  Locks in question are %s and %s", Thread.currentThread().getName(), exclusive ? "exclusive" : "shared", Util.prettyPrintTime(timeout, timeUnit), this.processingLock.readLock(), this.processingLock.writeLock()));
            }
            if (log.isDebugEnabled() && !exclusive) {
                this.debugReadLockHolders.add(Thread.currentThread());
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void releaseProcessingLock(boolean exclusive) {
        block5: {
            try {
                if (exclusive) {
                    this.processingLock.writeLock().unlock();
                } else {
                    this.processingLock.readLock().unlock();
                    if (log.isDebugEnabled()) {
                        this.debugReadLockHolders.remove(Thread.currentThread());
                    }
                }
            }
            catch (IllegalMonitorStateException imse) {
                if (!trace) break block5;
                log.trace("Did not own lock!");
            }
        }
    }
}

