/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.group.GroupManager;
import org.infinispan.remoting.transport.Address;

public abstract class AbstractConsistentHash
implements ConsistentHash {
    protected GroupManager groupManager;

    @Override
    public Map<Object, List<Address>> locateAll(Collection<Object> keys, int replCount) {
        HashMap<Object, List<Address>> locations = new HashMap<Object, List<Address>>();
        for (Object k : keys) {
            locations.put(k, this.locate(k, replCount));
        }
        return locations;
    }

    @Override
    public boolean isKeyLocalToAddress(Address a, Object key, int replCount) {
        return this.locate(key, replCount).contains(a);
    }

    public void setGroupManager(GroupManager groupManager) {
        this.groupManager = groupManager;
    }

    @Override
    public List<Address> getStateProvidersOnLeave(Address leaver, int replCount) {
        throw new UnsupportedOperationException("No longer supported");
    }

    @Override
    public List<Address> getStateProvidersOnJoin(Address joiner, int replCount) {
        throw new UnsupportedOperationException("No longer supported");
    }

    @Override
    public List<Address> getBackupsForNode(Address node, int replCount) {
        throw new UnsupportedOperationException("No longer supported");
    }

    public String toString() {
        return this.getClass().getSimpleName() + " {" + "caches=" + this.getCaches() + '}';
    }

    protected Object getGrouping(Object key) {
        String group = this.groupManager != null ? this.groupManager.getGroup(key) : null;
        return group != null ? group : key;
    }
}

