/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.control.RehashControlCommand;
import org.infinispan.commands.control.StateTransferControlCommand;
import org.infinispan.commands.module.ModuleCommandInitializer;
import org.infinispan.commands.read.DistributedExecuteCommand;
import org.infinispan.commands.read.EntrySetCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.read.KeySetCommand;
import org.infinispan.commands.read.MapReduceCommand;
import org.infinispan.commands.read.SizeCommand;
import org.infinispan.commands.read.ValuesCommand;
import org.infinispan.commands.remote.ClusteredGetCommand;
import org.infinispan.commands.remote.MultipleRpcCommand;
import org.infinispan.commands.remote.SingleRpcCommand;
import org.infinispan.commands.remote.recovery.CompleteTransactionCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTransactionsCommand;
import org.infinispan.commands.remote.recovery.GetInDoubtTxInfoCommand;
import org.infinispan.commands.remote.recovery.RemoveRecoveryInfoCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.EvictCommand;
import org.infinispan.commands.write.InvalidateCommand;
import org.infinispan.commands.write.InvalidateL1Command;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContextContainer;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.remoting.transport.Address;
import org.infinispan.transaction.RemoteTransaction;
import org.infinispan.transaction.TransactionTable;
import org.infinispan.transaction.xa.DldGlobalTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CommandsFactoryImpl
implements CommandsFactory {
    private static final Log log = LogFactory.getLog(CommandsFactoryImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private DataContainer dataContainer;
    private CacheNotifier notifier;
    private Cache cache;
    private String cacheName;
    SizeCommand cachedSizeCommand;
    KeySetCommand cachedKeySetCommand;
    ValuesCommand cachedValuesCommand;
    EntrySetCommand cachedEntrySetCommand;
    private InterceptorChain interceptorChain;
    private DistributionManager distributionManager;
    private InvocationContextContainer icc;
    private TransactionTable txTable;
    private Configuration configuration;
    private RecoveryManager recoveryManager;
    private Map<Byte, ModuleCommandInitializer> moduleCommandInitializers;

    @Inject
    public void setupDependencies(DataContainer container, CacheNotifier notifier, Cache cache, InterceptorChain interceptorChain, DistributionManager distributionManager, InvocationContextContainer icc, TransactionTable txTable, Configuration configuration, @ComponentName(value="org.infinispan.modules.command.initializers") Map<Byte, ModuleCommandInitializer> moduleCommandInitializers, RecoveryManager recoveryManager) {
        this.dataContainer = container;
        this.notifier = notifier;
        this.cache = cache;
        this.interceptorChain = interceptorChain;
        this.distributionManager = distributionManager;
        this.icc = icc;
        this.txTable = txTable;
        this.configuration = configuration;
        this.moduleCommandInitializers = moduleCommandInitializers;
        this.recoveryManager = recoveryManager;
    }

    @Start(priority=1)
    public void start() {
        this.cacheName = this.cache.getName();
    }

    @Override
    public PutKeyValueCommand buildPutKeyValueCommand(Object key, Object value, long lifespanMillis, long maxIdleTimeMillis, Set<Flag> flags) {
        return new PutKeyValueCommand(key, value, false, this.notifier, lifespanMillis, maxIdleTimeMillis, flags);
    }

    @Override
    public RemoveCommand buildRemoveCommand(Object key, Object value, Set<Flag> flags) {
        return new RemoveCommand(key, value, this.notifier, flags);
    }

    @Override
    public InvalidateCommand buildInvalidateCommand(Object ... keys) {
        return new InvalidateCommand(this.notifier, keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(boolean forRehash, Object ... keys) {
        return new InvalidateL1Command(forRehash, this.dataContainer, this.configuration, this.distributionManager, this.notifier, keys);
    }

    @Override
    public InvalidateCommand buildInvalidateFromL1Command(boolean forRehash, Collection<Object> keys) {
        return new InvalidateL1Command(forRehash, this.dataContainer, this.configuration, this.distributionManager, this.notifier, keys);
    }

    @Override
    public ReplaceCommand buildReplaceCommand(Object key, Object oldValue, Object newValue, long lifespan, long maxIdleTimeMillis, Set<Flag> flags) {
        return new ReplaceCommand(key, oldValue, newValue, lifespan, maxIdleTimeMillis, flags);
    }

    @Override
    public SizeCommand buildSizeCommand() {
        if (this.cachedSizeCommand == null) {
            this.cachedSizeCommand = new SizeCommand(this.dataContainer);
        }
        return this.cachedSizeCommand;
    }

    @Override
    public KeySetCommand buildKeySetCommand() {
        if (this.cachedKeySetCommand == null) {
            this.cachedKeySetCommand = new KeySetCommand(this.dataContainer);
        }
        return this.cachedKeySetCommand;
    }

    @Override
    public ValuesCommand buildValuesCommand() {
        if (this.cachedValuesCommand == null) {
            this.cachedValuesCommand = new ValuesCommand(this.dataContainer);
        }
        return this.cachedValuesCommand;
    }

    @Override
    public EntrySetCommand buildEntrySetCommand() {
        if (this.cachedEntrySetCommand == null) {
            this.cachedEntrySetCommand = new EntrySetCommand(this.dataContainer);
        }
        return this.cachedEntrySetCommand;
    }

    @Override
    public GetKeyValueCommand buildGetKeyValueCommand(Object key, Set<Flag> flags) {
        return new GetKeyValueCommand(key, this.notifier, flags);
    }

    @Override
    public PutMapCommand buildPutMapCommand(Map map, long lifespan, long maxIdleTimeMillis, Set<Flag> flags) {
        return new PutMapCommand(map, this.notifier, lifespan, maxIdleTimeMillis, flags);
    }

    @Override
    public ClearCommand buildClearCommand(Set<Flag> flags) {
        return new ClearCommand(this.notifier, flags);
    }

    @Override
    public EvictCommand buildEvictCommand(Object key) {
        return new EvictCommand(key, this.notifier);
    }

    @Override
    public PrepareCommand buildPrepareCommand(GlobalTransaction gtx, List<WriteCommand> modifications, boolean onePhaseCommit) {
        PrepareCommand command = new PrepareCommand(gtx, modifications, onePhaseCommit);
        command.setCacheName(this.cacheName);
        return command;
    }

    @Override
    public CommitCommand buildCommitCommand(GlobalTransaction gtx) {
        CommitCommand commitCommand = new CommitCommand(gtx);
        commitCommand.setCacheName(this.cacheName);
        return commitCommand;
    }

    @Override
    public RollbackCommand buildRollbackCommand(GlobalTransaction gtx) {
        RollbackCommand rollbackCommand = new RollbackCommand(gtx);
        rollbackCommand.setCacheName(this.cacheName);
        return rollbackCommand;
    }

    @Override
    public MultipleRpcCommand buildReplicateCommand(List<ReplicableCommand> toReplicate) {
        return new MultipleRpcCommand(toReplicate, this.cacheName);
    }

    @Override
    public SingleRpcCommand buildSingleRpcCommand(ReplicableCommand call) {
        return new SingleRpcCommand(this.cacheName, call);
    }

    @Override
    public StateTransferControlCommand buildStateTransferControlCommand(boolean block) {
        return new StateTransferControlCommand(block);
    }

    @Override
    public ClusteredGetCommand buildClusteredGetCommand(Object key, Set<Flag> flags) {
        return new ClusteredGetCommand(key, this.cacheName, flags);
    }

    @Override
    public void initializeReplicableCommand(ReplicableCommand c, boolean isRemote) {
        if (c == null) {
            return;
        }
        switch (c.getCommandId()) {
            case 8: {
                ((PutKeyValueCommand)c).init(this.notifier);
                break;
            }
            case 9: {
                ((PutMapCommand)c).init(this.notifier);
                break;
            }
            case 10: {
                ((RemoveCommand)c).init(this.notifier);
                break;
            }
            case 2: {
                MultipleRpcCommand rc = (MultipleRpcCommand)c;
                rc.init(this.interceptorChain, this.icc);
                if (rc.getCommands() == null) break;
                for (ReplicableCommand nested : rc.getCommands()) {
                    this.initializeReplicableCommand(nested, false);
                }
                break;
            }
            case 1: {
                SingleRpcCommand src = (SingleRpcCommand)c;
                src.init(this.interceptorChain, this.icc);
                if (src.getCommand() == null) break;
                this.initializeReplicableCommand(src.getCommand(), false);
                break;
            }
            case 6: {
                InvalidateCommand ic = (InvalidateCommand)c;
                ic.init(this.notifier);
                break;
            }
            case 7: {
                InvalidateL1Command ilc = (InvalidateL1Command)c;
                ilc.init(this.configuration, this.distributionManager, this.notifier, this.dataContainer);
                break;
            }
            case 12: {
                PrepareCommand pc = (PrepareCommand)c;
                pc.init(this.interceptorChain, this.icc, this.txTable);
                pc.initialize(this.notifier, this.recoveryManager);
                if (pc.getModifications() != null) {
                    for (WriteCommand nested : pc.getModifications()) {
                        this.initializeReplicableCommand(nested, false);
                    }
                }
                pc.markTransactionAsRemote(isRemote);
                if (!this.configuration.isEnableDeadlockDetection() || !isRemote) break;
                DldGlobalTransaction transaction = (DldGlobalTransaction)pc.getGlobalTransaction();
                transaction.setLocksHeldAtOrigin(pc.getAffectedKeys());
                break;
            }
            case 14: {
                CommitCommand commitCommand = (CommitCommand)c;
                commitCommand.init(this.interceptorChain, this.icc, this.txTable);
                commitCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 13: {
                RollbackCommand rollbackCommand = (RollbackCommand)c;
                rollbackCommand.init(this.interceptorChain, this.icc, this.txTable);
                rollbackCommand.markTransactionAsRemote(isRemote);
                break;
            }
            case 5: {
                ClearCommand cc = (ClearCommand)c;
                cc.init(this.notifier);
                break;
            }
            case 16: {
                ClusteredGetCommand clusteredGetCommand = (ClusteredGetCommand)c;
                clusteredGetCommand.initialize(this.icc, this, this.interceptorChain, this.distributionManager);
                break;
            }
            case 3: {
                DldGlobalTransaction gtx;
                RemoteTransaction transaction;
                LockControlCommand lcc = (LockControlCommand)c;
                lcc.init(this.interceptorChain, this.icc, this.txTable);
                lcc.markTransactionAsRemote(isRemote);
                if (!this.configuration.isEnableDeadlockDetection() || !isRemote || (transaction = this.txTable.getRemoteTransaction(gtx = (DldGlobalTransaction)lcc.getGlobalTransaction())) == null) break;
                if (!this.configuration.getCacheMode().isDistributed()) {
                    Set<Object> keys = this.txTable.getLockedKeysForRemoteTransaction(gtx);
                    GlobalTransaction gtx2 = transaction.getGlobalTransaction();
                    ((DldGlobalTransaction)gtx2).setLocksHeldAtOrigin(keys);
                    gtx.setLocksHeldAtOrigin(keys);
                    break;
                }
                GlobalTransaction gtx2 = transaction.getGlobalTransaction();
                ((DldGlobalTransaction)gtx2).setLocksHeldAtOrigin(gtx.getLocksHeldAtOrigin());
                break;
            }
            case 17: {
                RehashControlCommand rcc = (RehashControlCommand)c;
                rcc.init(this.distributionManager, this.configuration, this.dataContainer, this);
                break;
            }
            case 21: {
                GetInDoubtTransactionsCommand gptx = (GetInDoubtTransactionsCommand)c;
                gptx.init(this.recoveryManager);
                break;
            }
            case 22: {
                RemoveRecoveryInfoCommand ftx = (RemoveRecoveryInfoCommand)c;
                ftx.init(this.recoveryManager);
                break;
            }
            case 20: {
                MapReduceCommand mrc = (MapReduceCommand)c;
                mrc.init(this, this.interceptorChain, this.icc, this.distributionManager, this.cache.getAdvancedCache().getRpcManager().getAddress());
                break;
            }
            case 19: {
                DistributedExecuteCommand dec = (DistributedExecuteCommand)c;
                dec.init(this.cache);
                break;
            }
            case 23: {
                GetInDoubtTxInfoCommand gidTxInfoCommand = (GetInDoubtTxInfoCommand)c;
                gidTxInfoCommand.init(this.recoveryManager);
                break;
            }
            case 24: {
                CompleteTransactionCommand ccc = (CompleteTransactionCommand)c;
                ccc.init(this.recoveryManager);
                break;
            }
            default: {
                ModuleCommandInitializer mci = this.moduleCommandInitializers.get(c.getCommandId());
                if (mci != null) {
                    mci.initializeReplicableCommand(c, isRemote);
                    break;
                }
                if (!trace) break;
                log.tracef("Nothing to initialize for command: %s", c);
            }
        }
    }

    @Override
    public LockControlCommand buildLockControlCommand(Collection keys, boolean implicit, Set<Flag> flags) {
        return new LockControlCommand(keys, this.cacheName, flags, implicit);
    }

    @Override
    public RehashControlCommand buildRehashControlCommand(RehashControlCommand.Type type, Address sender, int viewId) {
        return new RehashControlCommand(this.cacheName, type, sender, viewId);
    }

    @Override
    public RehashControlCommand buildRehashControlCommand(RehashControlCommand.Type type, Address sender, int viewId, Map<Object, InternalCacheValue> state, ConsistentHash oldCH, ConsistentHash newCH) {
        return new RehashControlCommand(this.cacheName, type, sender, viewId, state, oldCH, newCH);
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public GetInDoubtTransactionsCommand buildGetInDoubtTransactionsCommand() {
        return new GetInDoubtTransactionsCommand(this.cacheName);
    }

    @Override
    public RemoveRecoveryInfoCommand buildRemoveRecoveryInfoCommand(Xid xid) {
        return new RemoveRecoveryInfoCommand(xid, this.cacheName);
    }

    @Override
    public <T> DistributedExecuteCommand<T> buildDistributedExecuteCommand(Callable<T> callable, Address sender, Collection keys) {
        return new DistributedExecuteCommand<T>(keys, callable);
    }

    @Override
    public MapReduceCommand buildMapReduceCommand(Mapper m, Reducer r, Address sender, Collection keys) {
        return new MapReduceCommand(m, r, this.cacheName, keys);
    }

    @Override
    public GetInDoubtTxInfoCommand buildGetInDoubtTxInfoCommand() {
        return new GetInDoubtTxInfoCommand(this.cacheName);
    }

    @Override
    public CompleteTransactionCommand buildCompleteTransactionCommand(Xid xid, boolean commit) {
        return new CompleteTransactionCommand(this.cacheName, xid, commit);
    }

    @Override
    public RemoveRecoveryInfoCommand buildRemoveRecoveryInfoCommand(long internalId) {
        return new RemoveRecoveryInfoCommand(internalId, this.cacheName);
    }
}

