/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.infinispan.atomic.AtomicHashMap;
import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.atomic.Operation;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AtomicHashMapDelta
implements Delta {
    private static final Log log = LogFactory.getLog(AtomicHashMapDelta.class);
    private static final boolean trace = log.isTraceEnabled();
    private List<Operation> changeLog;

    @Override
    public DeltaAware merge(DeltaAware d) {
        AtomicHashMap other = d != null && d instanceof AtomicHashMap ? (AtomicHashMap)d : new AtomicHashMap();
        if (this.changeLog != null) {
            for (Operation o : this.changeLog) {
                o.replay(other.delegate);
            }
        }
        other.commit();
        return other;
    }

    public void addOperation(Operation o) {
        if (this.changeLog == null) {
            this.changeLog = new LinkedList<Operation>();
        }
        this.changeLog.add(o);
    }

    public String toString() {
        return "AtomicHashMapDelta{changeLog=" + this.changeLog + '}';
    }

    public int getChangeLogSize() {
        return this.changeLog == null ? 0 : this.changeLog.size();
    }

    public static class Externalizer
    extends AbstractExternalizer<AtomicHashMapDelta> {
        @Override
        public void writeObject(ObjectOutput output, AtomicHashMapDelta delta) throws IOException {
            if (trace) {
                log.tracef("Serializing changeLog %s", delta.changeLog);
            }
            output.writeObject(delta.changeLog);
        }

        @Override
        public AtomicHashMapDelta readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AtomicHashMapDelta delta = new AtomicHashMapDelta();
            delta.changeLog = (List)input.readObject();
            if (trace) {
                log.tracef("Deserialized changeLog %s", delta.changeLog);
            }
            return delta;
        }

        @Override
        public Integer getId() {
            return 46;
        }

        @Override
        public Set<Class<? extends AtomicHashMapDelta>> getTypeClasses() {
            return Util.asSet(AtomicHashMapDelta.class);
        }
    }
}

