/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import javax.servlet.Servlet;
import javax.xml.ws.WebServiceProvider;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.web.deployment.WarMetaData;
import org.jboss.as.webservices.metadata.WebServiceDeclaration;
import org.jboss.as.webservices.metadata.WebServiceDeployment;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.jboss.metadata.common.jboss.WebserviceDescriptionMetaData;
import org.jboss.metadata.common.jboss.WebserviceDescriptionsMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMetaData;

public final class ASHelper {
    public static final String CONTAINER_NAME = "org.jboss.wsf.spi.invocation.ContainerName";
    private static final Logger LOGGER = Logger.getLogger(ASHelper.class);
    public static final DotName WEB_SERVICE_ANNOTATION = DotName.createSimple((String)WebService.class.getName());
    public static final DotName WEB_SERVICE_PROVIDER_ANNOTATION = DotName.createSimple((String)WebServiceProvider.class.getName());
    private static final String SERVLET_CLASS_NAME = Servlet.class.getName();

    private ASHelper() {
    }

    public static boolean isWebServiceDeployment(DeploymentUnit unit) {
        return ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.DEPLOYMENT_TYPE_KEY) != null;
    }

    public static List<ServletMetaData> getJaxwsServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, true);
    }

    public static List<ServletMetaData> getJaxrpcServlets(DeploymentUnit unit) {
        return ASHelper.getWebServiceServlets(unit, false);
    }

    public static List<WebServiceDeclaration> getJaxwsEjbs(DeploymentUnit unit) {
        WebServiceDeployment wsDeployment = ASHelper.getRequiredAttachment(unit, WSAttachmentKeys.WEBSERVICE_DEPLOYMENT_KEY);
        return Collections.unmodifiableList(wsDeployment.getServiceEndpoints());
    }

    public static String getEndpointName(ServletMetaData servletMD) {
        String endpointClass = servletMD.getServletClass();
        return endpointClass != null ? endpointClass.trim() : null;
    }

    public static ServletMetaData getServletForName(JBossWebMetaData jbossWebMD, String servletName) {
        for (JBossServletMetaData servlet : jbossWebMD.getServlets()) {
            if (!servlet.getName().equals(servletName)) continue;
            return servlet;
        }
        throw new IllegalStateException("Cannot find servlet for link: " + servletName);
    }

    public static <A> A getRequiredAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        Object value = unit.getAttachment(key);
        if (value == null) {
            LOGGER.error((Object)("Cannot find attachment in deployment unit: " + key));
            throw new IllegalStateException();
        }
        return (A)value;
    }

    public static <A> A getOptionalAttachment(DeploymentUnit unit, AttachmentKey<A> key) {
        return (A)unit.getAttachment(key);
    }

    public static boolean hasAttachment(DeploymentUnit unit, AttachmentKey<?> key) {
        return ASHelper.getOptionalAttachment(unit, key) != null;
    }

    public static WebserviceDescriptionMetaData getWebserviceDescriptionMetaData(WebserviceDescriptionsMetaData wsDescriptionsMD) {
        if (wsDescriptionsMD != null) {
            if (wsDescriptionsMD.size() > 1) {
                LOGGER.warn((Object)"Multiple <webservice-description> elements not supported");
            }
            if (wsDescriptionsMD.size() > 0) {
                return (WebserviceDescriptionMetaData)wsDescriptionsMD.iterator().next();
            }
        }
        return null;
    }

    private static List<ServletMetaData> getWebServiceServlets(DeploymentUnit unit, boolean jaxws) {
        JBossWebMetaData jbossWebMD = ASHelper.getJBossWebMetaData(unit);
        return ASHelper.selectWebServiceServlets(unit, jbossWebMD.getServlets(), jaxws);
    }

    private static <T extends ServletMetaData> List<ServletMetaData> selectWebServiceServlets(DeploymentUnit unit, Collection<T> smd, boolean jaxws) {
        if (smd == null) {
            return Collections.emptyList();
        }
        CompositeIndex index = (CompositeIndex)ASHelper.getOptionalAttachment(unit, Attachments.COMPOSITE_ANNOTATION_INDEX);
        ArrayList<ServletMetaData> endpoints = new ArrayList<ServletMetaData>();
        for (ServletMetaData servletMD : smd) {
            boolean isWebServiceEndpoint = index != null ? ASHelper.isWebserviceEndpoint(servletMD, index, jaxws) : ASHelper.isWebserviceEndpoint(servletMD, (ClassLoader)unit.getAttachment(WSAttachmentKeys.CLASSLOADER_KEY), jaxws);
            if (!isWebServiceEndpoint) continue;
            endpoints.add(servletMD);
        }
        return endpoints;
    }

    private static boolean isWebserviceEndpoint(ServletMetaData servletMD, CompositeIndex index, boolean jaxws) {
        String endpointClassName = ASHelper.getEndpointName(servletMD);
        if (ASHelper.isJSP(endpointClassName)) {
            return false;
        }
        DotName endpointDotName = DotName.createSimple((String)endpointClassName);
        ClassInfo endpointClassInfo = index.getClassByName(endpointDotName);
        if (endpointClassInfo != null) {
            if (jaxws) {
                if (endpointClassInfo.annotations().containsKey(WEB_SERVICE_ANNOTATION)) {
                    return true;
                }
                if (endpointClassInfo.annotations().containsKey(WEB_SERVICE_PROVIDER_ANNOTATION)) {
                    return true;
                }
            } else if (!ASHelper.isServlet(endpointClassInfo, index)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isWebserviceEndpoint(ServletMetaData servletMD, ClassLoader loader, boolean jaxws) {
        String endpointClassName = ASHelper.getEndpointName(servletMD);
        if (ASHelper.isJSP(endpointClassName)) {
            return false;
        }
        Class<?> endpointClass = ASHelper.getEndpointClass(endpointClassName, loader);
        if (endpointClass != null) {
            if (jaxws) {
                if (endpointClass.isAnnotationPresent(WebService.class)) {
                    return true;
                }
                if (endpointClass.isAnnotationPresent(WebServiceProvider.class)) {
                    return true;
                }
            } else if (!Servlet.class.isAssignableFrom(endpointClass)) {
                return true;
            }
        }
        return false;
    }

    private static Class<?> getEndpointClass(String endpointClassName, ClassLoader loader) {
        try {
            Class<?> endpointClass = loader.loadClass(endpointClassName);
            return !Servlet.class.isAssignableFrom(endpointClass) ? endpointClass : null;
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.warn((Object)("Cannot load servlet class: " + endpointClassName), (Throwable)cnfe);
            return null;
        }
    }

    private static boolean isJSP(String endpointClassName) {
        return endpointClassName == null || endpointClassName.length() == 0;
    }

    protected static boolean isServlet(ClassInfo info, CompositeIndex index) {
        HashSet<DotName> interfacesToProcess = new HashSet<DotName>();
        HashSet<DotName> processedInterfaces = new HashSet<DotName>();
        boolean b = ASHelper.isServlet(info, index, interfacesToProcess);
        while (!b && !interfacesToProcess.isEmpty()) {
            Iterator toProcess = interfacesToProcess.iterator();
            DotName dn = (DotName)toProcess.next();
            toProcess.remove();
            processedInterfaces.add(dn);
            b = ASHelper.extendsServlet(dn, index, interfacesToProcess, processedInterfaces);
        }
        return b;
    }

    private static boolean isServlet(ClassInfo info, CompositeIndex index, Set<DotName> interfaces) {
        ClassInfo su;
        for (DotName dn : info.interfaces()) {
            if (SERVLET_CLASS_NAME.equals(dn.toString())) {
                return true;
            }
            interfaces.add(dn);
        }
        DotName superName = info.superName();
        if (!"java.lang.Object".equals(superName.toString()) && (su = index.getClassByName(superName)) != null) {
            return ASHelper.isServlet(su, index, interfaces);
        }
        return false;
    }

    private static boolean extendsServlet(DotName current, CompositeIndex index, Set<DotName> interfacesToProcess, Set<DotName> processedInterfaces) {
        ClassInfo ci = index.getClassByName(current);
        if (ci != null) {
            DotName superName = ci.superName();
            if (SERVLET_CLASS_NAME.equals(superName.toString())) {
                return true;
            }
            if (!"java.lang.Object".equals(superName.toString()) && !processedInterfaces.contains(superName)) {
                interfacesToProcess.add(superName);
            }
        }
        return false;
    }

    public static JBossWebMetaData getJBossWebMetaData(DeploymentUnit unit) {
        WarMetaData warMetaData = (WarMetaData)ASHelper.getOptionalAttachment(unit, WarMetaData.ATTACHMENT_KEY);
        JBossWebMetaData result = null;
        if (warMetaData != null) {
            result = warMetaData.getMergedJBossWebMetaData();
            if (result == null) {
                result = warMetaData.getJbossWebMetaData();
            }
        } else {
            result = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JBOSSWEB_METADATA_KEY);
        }
        return result;
    }

    public static List<AnnotationInstance> getAnnotations(DeploymentUnit unit, DotName annotation) {
        CompositeIndex compositeIndex = (CompositeIndex)ASHelper.getRequiredAttachment(unit, Attachments.COMPOSITE_ANNOTATION_INDEX);
        return compositeIndex.getAnnotations(annotation);
    }
}

