/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.publish;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import org.apache.catalina.Container;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.ContextConfig;
import org.apache.tomcat.InstanceManager;
import org.jboss.as.controller.PathElement;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.web.deployment.WebCtxLoader;
import org.jboss.as.webservices.deployers.deployment.DeploymentAspectsProvider;
import org.jboss.as.webservices.deployers.deployment.WSDeploymentBuilder;
import org.jboss.as.webservices.publish.SecurityActions;
import org.jboss.as.webservices.service.ServerConfigService;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.as.webservices.util.WSServices;
import org.jboss.as.webservices.util.WebMetaDataHelper;
import org.jboss.dmr.ModelNode;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossServletsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.ServletMappingMetaData;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.ws.common.deployment.DeploymentAspectManagerImpl;
import org.jboss.wsf.spi.classloading.ClassLoaderProvider;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.WSFServlet;
import org.jboss.wsf.spi.publish.Context;
import org.jboss.wsf.spi.publish.EndpointPublisher;

public final class EndpointPublisherImpl
implements EndpointPublisher {
    private Host host;

    public EndpointPublisherImpl(Host host) {
        this.host = host;
    }

    public Context publish(String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap) throws Exception {
        return this.publish(null, context, loader, urlPatternToClassNameMap);
    }

    public Context publish(ServiceTarget target, String context, ClassLoader loader, Map<String, String> urlPatternToClassNameMap) throws Exception {
        WSEndpointDeploymentUnit unit = new WSEndpointDeploymentUnit(loader, context, urlPatternToClassNameMap);
        return new Context(context, this.publish(target, unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Endpoint> publish(ServiceTarget target, WSEndpointDeploymentUnit unit) throws Exception {
        List<DeploymentAspect> aspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
        ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
        Deployment dep = null;
        try {
            SecurityActions.setContextClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
            WSDeploymentBuilder.getInstance().build(unit);
            dep = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
            dep.addAttachment(ServiceTarget.class, (Object)target);
            DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
            dam.setDeploymentAspects(aspects);
            dam.deploy(dep);
        }
        finally {
            if (dep != null) {
                dep.removeAttachment(ServiceTarget.class);
            }
            SecurityActions.setContextClassLoader(origClassLoader);
        }
        Deployment deployment = (Deployment)unit.getAttachment(WSAttachmentKeys.DEPLOYMENT_KEY);
        deployment.addAttachment(StandardContext.class, (Object)EndpointPublisherImpl.startWebApp(this.host, unit));
        return deployment.getService().getEndpoints();
    }

    private static StandardContext startWebApp(Host host, WSEndpointDeploymentUnit unit) throws Exception {
        StandardContext context = new StandardContext();
        try {
            JBossWebMetaData jbwebMD = (JBossWebMetaData)unit.getAttachment(WSAttachmentKeys.JBOSSWEB_METADATA_KEY);
            context.setPath(jbwebMD.getContextRoot());
            context.addLifecycleListener((LifecycleListener)new ContextConfig());
            ServerConfigService config = (ServerConfigService)unit.getServiceRegistry().getService(WSServices.CONFIG_SERVICE).getService();
            File docBase = new File(config.getValue().getServerTempDir(), jbwebMD.getContextRoot());
            if (!docBase.exists()) {
                docBase.mkdirs();
            }
            context.setDocBase(docBase.getPath());
            WebCtxLoader loader = new WebCtxLoader((ClassLoader)unit.getAttachment(WSAttachmentKeys.CLASSLOADER_KEY));
            loader.setContainer((Container)host);
            context.setLoader((Loader)loader);
            context.setInstanceManager((InstanceManager)new LocalInstanceManager());
            EndpointPublisherImpl.addServlets(jbwebMD, context);
            host.addChild((Container)context);
            context.create();
        }
        catch (Exception e) {
            throw new Exception("Failed to create context", e);
        }
        try {
            context.start();
        }
        catch (LifecycleException e) {
            throw new Exception("Failed to start context", e);
        }
        return context;
    }

    private static void addServlets(JBossWebMetaData jbwebMD, StandardContext context) {
        for (JBossServletMetaData smd : jbwebMD.getServlets()) {
            String sc = smd.getServletClass();
            if (!sc.equals(WSFServlet.class.getName())) continue;
            String servletName = smd.getServletName();
            List params = smd.getInitParam();
            List urlPatterns = null;
            for (ServletMappingMetaData smmd : jbwebMD.getServletMappings()) {
                if (!smmd.getServletName().equals(servletName)) continue;
                urlPatterns = smmd.getUrlPatterns();
                break;
            }
            WSFServlet wsfs = new WSFServlet();
            Wrapper wsfsWrapper = context.createWrapper();
            wsfsWrapper.setName(servletName);
            wsfsWrapper.setServlet((Servlet)wsfs);
            wsfsWrapper.setServletClass(WSFServlet.class.getName());
            for (ParamValueMetaData param : params) {
                wsfsWrapper.addInitParameter(param.getParamName(), param.getParamValue());
            }
            context.addChild((Container)wsfsWrapper);
            for (String urlPattern : urlPatterns) {
                context.addServletMapping(urlPattern, servletName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(Context context) throws Exception {
        Deployment deployment = ((Endpoint)context.getEndpoints().get(0)).getService().getDeployment();
        List<DeploymentAspect> aspects = DeploymentAspectsProvider.getSortedDeploymentAspects();
        try {
            EndpointPublisherImpl.stopWebApp((StandardContext)deployment.getAttachment(StandardContext.class));
        }
        finally {
            ClassLoader origClassLoader = SecurityActions.getContextClassLoader();
            try {
                SecurityActions.setContextClassLoader(ClassLoaderProvider.getDefaultProvider().getServerIntegrationClassLoader());
                DeploymentAspectManagerImpl dam = new DeploymentAspectManagerImpl();
                dam.setDeploymentAspects(aspects);
                dam.undeploy(deployment);
            }
            finally {
                SecurityActions.setContextClassLoader(origClassLoader);
            }
        }
    }

    private static void stopWebApp(StandardContext context) throws Exception {
        try {
            Container container = context.getParent();
            container.removeChild((Container)context);
            context.stop();
        }
        catch (LifecycleException e) {
            throw new Exception("Exception while stopping context", e);
        }
        try {
            context.destroy();
        }
        catch (Exception e) {
            throw new Exception("Exception while destroying context", e);
        }
    }

    public static class WSEndpointDeploymentUnit
    extends SimpleAttachable
    implements DeploymentUnit {
        private String deploymentName;

        public WSEndpointDeploymentUnit(ClassLoader loader, String context, Map<String, String> urlPatternToClassName) {
            this.deploymentName = context + ".deployment";
            JBossWebMetaData jbossWebMetaData = new JBossWebMetaData();
            jbossWebMetaData.setContextRoot(context);
            for (String urlPattern : urlPatternToClassName.keySet()) {
                this.addEndpoint(jbossWebMetaData, urlPatternToClassName.get(urlPattern), urlPattern);
            }
            this.putAttachment(WSAttachmentKeys.JBOSSWEB_METADATA_KEY, jbossWebMetaData);
            this.putAttachment(WSAttachmentKeys.DEPLOYMENT_TYPE_KEY, Deployment.DeploymentType.JAXWS_JSE);
            this.putAttachment(WSAttachmentKeys.CLASSLOADER_KEY, loader);
        }

        private void addEndpoint(JBossWebMetaData jbossWebMetaData, String className, String urlPattern) {
            JBossServletsMetaData servlets = WebMetaDataHelper.getServlets(jbossWebMetaData);
            WebMetaDataHelper.newServlet(className, className, servlets);
            List<ServletMappingMetaData> servletMappings = WebMetaDataHelper.getServletMappings(jbossWebMetaData);
            if (urlPattern == null) {
                urlPattern = "/*";
            } else if (!(urlPattern = urlPattern.trim()).startsWith("/")) {
                urlPattern = "/" + urlPattern;
            }
            List<String> urlPatterns = WebMetaDataHelper.getUrlPatterns(urlPattern);
            WebMetaDataHelper.newServletMapping(className, urlPatterns, servletMappings);
        }

        public ServiceName getServiceName() {
            return ServiceName.JBOSS.append(new String[]{"ws-endpoint-deployment"}).append(new String[]{this.deploymentName});
        }

        public DeploymentUnit getParent() {
            return null;
        }

        public String getName() {
            return this.deploymentName;
        }

        public ServiceRegistry getServiceRegistry() {
            return WSServices.getContainerRegistry();
        }

        public ModelNode getDeploymentSubsystemModel(String subsystemName) {
            throw new RuntimeException("Can't get the deployment submodel from a " + WSEndpointDeploymentUnit.class + " instance");
        }

        public ModelNode createDeploymentSubModel(String subsystemName, PathElement address) {
            throw new RuntimeException("Can't create a deployment submodel from a " + WSEndpointDeploymentUnit.class + " instance");
        }
    }

    private static class LocalInstanceManager
    implements InstanceManager {
        LocalInstanceManager() {
        }

        public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(className).newInstance();
        }

        public Object newInstance(String fqcn, ClassLoader classLoader) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
            return Class.forName(fqcn, false, classLoader).newInstance();
        }

        public Object newInstance(Class<?> c) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
            return c.newInstance();
        }

        public void newInstance(Object o) throws IllegalAccessException, InvocationTargetException, NamingException {
            throw new IllegalStateException();
        }

        public void destroyInstance(Object o) throws IllegalAccessException, InvocationTargetException {
        }
    }
}

