/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.BundleManager;
import org.jboss.osgi.framework.internal.BundleReferenceClassLoader;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.framework.internal.SystemPackagesPlugin;
import org.osgi.framework.Bundle;

final class DefaultFrameworkModuleProvider
extends AbstractPluginService<FrameworkModuleProvider>
implements FrameworkModuleProvider {
    final Logger log = Logger.getLogger(DefaultFrameworkModuleProvider.class);
    private static final ModuleIdentifier FRAMEWORK_MODULE_IDENTIFIER = ModuleIdentifier.create((String)"jbosgi.framework");
    private final InjectedValue<SystemPackagesPlugin> injectedSystemPackages = new InjectedValue();
    private final InjectedValue<Module> injectedSystemModule = new InjectedValue();
    private Module frameworkModule;

    static void addService(ServiceTarget serviceTarget) {
        DefaultFrameworkModuleProvider service = new DefaultFrameworkModuleProvider();
        ServiceBuilder builder = serviceTarget.addService(Services.FRAMEWORK_MODULE_PROVIDER, (Service)service);
        builder.addDependency(InternalServices.SYSTEM_PACKAGES_PLUGIN, SystemPackagesPlugin.class, service.injectedSystemPackages);
        builder.addDependency(Services.SYSTEM_MODULE_PROVIDER, Module.class, service.injectedSystemModule);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private DefaultFrameworkModuleProvider() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.frameworkModule = null;
    }

    public FrameworkModuleProvider getValue() {
        return this;
    }

    @Override
    public Module getFrameworkModule(Bundle bundle) {
        if (this.frameworkModule == null) {
            SystemBundleState systemBundle = (SystemBundleState)bundle;
            this.frameworkModule = this.createFrameworkModule(systemBundle);
        }
        return this.frameworkModule;
    }

    private Module createFrameworkModule(SystemBundleState systemBundle) {
        Module systemModule = (Module)this.injectedSystemModule.getValue();
        ModuleIdentifier systemIdentifier = systemModule.getIdentifier();
        ModuleSpec.Builder specBuilder = ModuleSpec.build((ModuleIdentifier)FRAMEWORK_MODULE_IDENTIFIER);
        specBuilder.addDependency(DependencySpec.createModuleDependencySpec((PathFilter)PathFilters.acceptAll(), (PathFilter)PathFilters.acceptAll(), (ModuleLoader)systemModule.getModuleLoader(), (ModuleIdentifier)systemIdentifier, (boolean)false));
        SystemPackagesPlugin systemPackagesPlugin = (SystemPackagesPlugin)((Object)this.injectedSystemPackages.getValue());
        PathFilter frameworkFilter = systemPackagesPlugin.getFrameworkPackageFilter();
        final ClassLoader classLoader = BundleManager.class.getClassLoader();
        LocalLoader localLoader = new LocalLoader(){

            public Class<?> loadClassLocal(String name, boolean resolve) {
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    return null;
                }
            }

            public List<Resource> loadResourceLocal(String name) {
                return Collections.emptyList();
            }
        };
        Set<String> frameworkPackagePaths = systemPackagesPlugin.getFrameworkPackagePaths();
        specBuilder.addDependency(DependencySpec.createLocalDependencySpec((PathFilter)frameworkFilter, (PathFilter)PathFilters.acceptAll(), (LocalLoader)localLoader, frameworkPackagePaths));
        specBuilder.setModuleClassLoaderFactory(new BundleReferenceClassLoader.Factory<SystemBundleState>(systemBundle));
        try {
            final ModuleSpec moduleSpec = specBuilder.create();
            ModuleLoader moduleLoader = new ModuleLoader(){

                protected ModuleSpec findModule(ModuleIdentifier identifier) throws ModuleLoadException {
                    return moduleSpec.getModuleIdentifier().equals(identifier) ? moduleSpec : null;
                }

                public String toString() {
                    return ((Object)((Object)this)).getClass().getSimpleName();
                }
            };
            return moduleLoader.loadModule(specBuilder.getIdentifier());
        }
        catch (ModuleLoadException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

