/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.webservices;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.metadata.webservices.PortComponentMetaData;
import org.jboss.wsf.spi.metadata.webservices.WebservicesMetaData;

public class WebserviceDescriptionMetaData {
    private static final ResourceBundle bundle = BundleUtils.getBundle(WebserviceDescriptionMetaData.class);
    private static final Logger log = Logger.getLogger(WebserviceDescriptionMetaData.class);
    private WebservicesMetaData webservices;
    private String webserviceDescriptionName;
    private String wsdlFile;
    private String jaxrpcMappingFile;
    private ArrayList<PortComponentMetaData> portComponents = new ArrayList();

    public WebserviceDescriptionMetaData(WebservicesMetaData webservices) {
        this.webservices = webservices;
    }

    public WebservicesMetaData getWebservices() {
        return this.webservices;
    }

    public void addPortComponent(PortComponentMetaData portComponent) {
        this.portComponents.add(portComponent);
    }

    public PortComponentMetaData[] getPortComponents() {
        PortComponentMetaData[] array = new PortComponentMetaData[this.portComponents.size()];
        this.portComponents.toArray(array);
        return array;
    }

    public Collection<QName> getPortComponentQNames() {
        HashMap<String, QName> map = new HashMap<String, QName>();
        for (PortComponentMetaData pcm : this.portComponents) {
            QName qname = pcm.getWsdlPort();
            map.put(qname.getPrefix(), qname);
        }
        return map.values();
    }

    public PortComponentMetaData getPortComponentByWsdlPort(String name) {
        ArrayList<String> pcNames = new ArrayList<String>();
        for (PortComponentMetaData pc : this.portComponents) {
            String wsdlPortName = pc.getWsdlPort().getLocalPart();
            if (wsdlPortName.equals(name)) {
                return pc;
            }
            pcNames.add(wsdlPortName);
        }
        log.error((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_GET_PORT_COMPONENT_NAME", (Object[])new Object[]{name, pcNames}));
        return null;
    }

    public String getWebserviceDescriptionName() {
        return this.webserviceDescriptionName;
    }

    public void setWebserviceDescriptionName(String webserviceDescriptionName) {
        this.webserviceDescriptionName = webserviceDescriptionName;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public String getJaxrpcMappingFile() {
        return this.jaxrpcMappingFile;
    }

    public void setJaxrpcMappingFile(String jaxrpcMappingFile) {
        this.jaxrpcMappingFile = jaxrpcMappingFile;
    }

    public String serialize() {
        StringBuilder buffer = new StringBuilder("<webservice-description>");
        buffer.append("<webservice-description-name>").append(this.webserviceDescriptionName).append("</webservice-description-name>");
        buffer.append("<wsdl-file>").append(this.wsdlFile).append("</wsdl-file>");
        buffer.append("<jaxrpc-mapping-file>").append(this.jaxrpcMappingFile).append("</jaxrpc-mapping-file>");
        for (PortComponentMetaData pm : this.portComponents) {
            buffer.append(pm.serialize());
        }
        buffer.append("</webservice-description>");
        return buffer.toString();
    }
}

