/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.injection;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.metadata.injection.InjectionMetaData;
import org.jboss.wsf.spi.metadata.injection.ReferenceResolver;

public final class InjectionsMetaData {
    private static final ResourceBundle bundle = BundleUtils.getBundle(InjectionsMetaData.class);
    private static final Collection<InjectionMetaData> EMPTY_LIST = Collections.emptyList();
    private final Collection<InjectionMetaData> injections;
    private final Map<Class<? extends Annotation>, ReferenceResolver> referenceResolvers;

    public InjectionsMetaData(Collection<InjectionMetaData> injections, Map<Class<? extends Annotation>, ReferenceResolver> resolvers) {
        if (injections == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"INJECTIONS_METADATA_LIST_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (resolvers == null || resolvers.size() == 0) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"REFERENCE_RESOLVERS_LIST_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        this.injections = injections;
        this.referenceResolvers = resolvers;
    }

    public Collection<InjectionMetaData> getInjectionsMetaData(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CLASS_CANNOT_BE_NULL", (Object[])new Object[0]));
        }
        if (this.injections.size() == 0) {
            return EMPTY_LIST;
        }
        LinkedList<InjectionMetaData> retVal = null;
        for (InjectionMetaData injectionMD : this.injections) {
            if (!clazz.getName().equals(injectionMD.getTargetClass()) || !injectionMD.isEnvEntryValueSpecified()) continue;
            if (retVal == null) {
                retVal = new LinkedList<InjectionMetaData>();
            }
            retVal.add(injectionMD);
        }
        return retVal == null ? EMPTY_LIST : retVal;
    }

    public ReferenceResolver getResolver(Class<? extends Annotation> annotation) {
        ReferenceResolver resolver = this.referenceResolvers.get(annotation);
        if (resolver == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"NO_REGISTERED_REFERENCE_RESOLVER_FOR", (Object[])new Object[]{annotation}));
        }
        return resolver;
    }
}

