/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.HashMap;
import java.util.Map;
import org.hornetq.core.management.impl.HornetQServerControlImpl;
import org.hornetq.core.server.HornetQServer;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class HornetQServerControlWriteHandler
extends ServerWriteAttributeOperationHandler {
    public static final HornetQServerControlWriteHandler INSTANCE = new HornetQServerControlWriteHandler();
    private final Map<String, AttributeDefinition> attributes = new HashMap<String, AttributeDefinition>();
    private final Map<String, AttributeDefinition> runtimeAttributes = new HashMap<String, AttributeDefinition>();

    private HornetQServerControlWriteHandler() {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            this.attributes.put(attr.getName(), attr);
        }
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_WRITE_ATTRIBUTES) {
            this.runtimeAttributes.put(attr.getName(), attr);
        }
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateParameter(name, value);
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
        AttributeDefinition attr = this.attributes.get(name);
        attr.getValidator().validateResolvedParameter(name, value);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        AttributeDefinition attr = this.runtimeAttributes.get(attributeName);
        if (attr != null) {
            ServiceRegistry registry = context.getServiceRegistry(true);
            ServiceController hqService = registry.getService(MessagingServices.JBOSS_MESSAGING);
            if (hqService != null && hqService.getState() == ServiceController.State.UP) {
                block11: {
                    HornetQServerControlImpl serverControl = ((HornetQServer)HornetQServer.class.cast(hqService.getValue())).getHornetQServerControl();
                    try {
                        if (attributeName.equals(CommonAttributes.FAILOVER_ON_SHUTDOWN.getName())) {
                            serverControl.setFailoverOnServerShutdown(newValue.resolve().asBoolean());
                            break block11;
                        }
                        if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_SAMPLE_PERIOD.getName())) {
                            serverControl.setMessageCounterSamplePeriod(newValue.resolve().asLong());
                            break block11;
                        }
                        if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_MAX_DAY_HISTORY.getName())) {
                            serverControl.setMessageCounterMaxDayCount(newValue.resolve().asInt());
                            break block11;
                        }
                        if (attributeName.equals(CommonAttributes.MESSAGE_COUNTER_ENABLED.getName())) {
                            boolean enabled = newValue.resolve().asBoolean();
                            if (enabled) {
                                serverControl.enableMessageCounters();
                            } else {
                                serverControl.disableMessageCounters();
                            }
                            break block11;
                        }
                        throw new UnsupportedOperationException(String.format("Runtime handling for %s is not implemented", attributeName));
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return false;
            }
            throw new IllegalStateException(String.format("Cannot apply attribue %s ti runtime; service %s is not in state %s, it is in state %s", attributeName, MessagingServices.JBOSS_MESSAGING, ServiceController.State.UP, hqService.getState()));
        }
        return true;
    }
}

