/*
 * Decompiled with CFR 0.152.
 */
package org.xnio;

import java.util.HashSet;
import java.util.Set;
import org.jboss.logging.Logger;
import org.xnio.ChannelThread;

public abstract class AbstractChannelThread
implements ChannelThread {
    private static final Logger listenerLog = Logger.getLogger((String)"org.xnio.listener");
    private static final int UP = 0;
    private static final int STOPPING = 1;
    private static final int DOWN = 2;
    private volatile int state = 0;
    private final Set<ChannelThread.Listener> listenerSet = new HashSet<ChannelThread.Listener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        ChannelThread.Listener[] listeners;
        Set<ChannelThread.Listener> listenerSet;
        Set<ChannelThread.Listener> set = listenerSet = this.listenerSet;
        synchronized (set) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            listeners = listenerSet.toArray(new ChannelThread.Listener[listenerSet.size()]);
        }
        for (ChannelThread.Listener listener : listeners) {
            this.doHandleTerminationInitiated(listener);
        }
        this.startShutdown();
    }

    private void doHandleTerminationInitiated(ChannelThread.Listener listener) {
        try {
            listener.handleTerminationInitiated(this);
        }
        catch (Throwable t) {
            AbstractChannelThread.logFailure(t);
        }
    }

    protected final void checkState() throws IllegalStateException {
        if (this.state != 0) {
            throw new IllegalStateException(String.format("Cannot add channel to %s (stopping)", this));
        }
    }

    protected final Object getLock() {
        return this.listenerSet;
    }

    protected final boolean isStopping() {
        return this.state >= 1;
    }

    protected abstract void startShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void shutdownFinished() {
        ChannelThread.Listener[] listeners;
        Set<ChannelThread.Listener> listenerSet;
        Set<ChannelThread.Listener> set = listenerSet = this.listenerSet;
        synchronized (set) {
            this.state = 2;
            listeners = listenerSet.toArray(new ChannelThread.Listener[listenerSet.size()]);
            listenerSet.clear();
            listenerSet.notifyAll();
        }
        for (ChannelThread.Listener listener : listeners) {
            this.doHandleTerminationComplete(listener);
        }
    }

    private void doHandleTerminationComplete(ChannelThread.Listener listener) {
        try {
            listener.handleTerminationComplete(this);
        }
        catch (Throwable t) {
            AbstractChannelThread.logFailure(t);
        }
    }

    private static void logFailure(Throwable t) {
        listenerLog.error((Object)"Listener invocation failed", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void awaitTermination() throws InterruptedException {
        Set<ChannelThread.Listener> listenerSet;
        Set<ChannelThread.Listener> set = listenerSet = this.listenerSet;
        synchronized (set) {
            while (this.state != 2) {
                listenerSet.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addTerminationListener(ChannelThread.Listener listener) {
        int state;
        Set<ChannelThread.Listener> listenerSet;
        Set<ChannelThread.Listener> set = listenerSet = this.listenerSet;
        synchronized (set) {
            state = this.state;
            switch (state) {
                case 0: {
                    listenerSet.add(listener);
                    return;
                }
                case 1: {
                    listenerSet.add(listener);
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this.doHandleTerminationInitiated(listener);
        if (state == 2) {
            this.doHandleTerminationComplete(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeTerminationListener(ChannelThread.Listener listener) {
        Set<ChannelThread.Listener> listenerSet;
        Set<ChannelThread.Listener> set = listenerSet = this.listenerSet;
        synchronized (set) {
            listenerSet.remove(listener);
        }
    }
}

