/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.osgi.parser;

import java.util.Locale;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.osgi.parser.OSGiSubsystemProviders;
import org.jboss.as.osgi.parser.SubsystemState;
import org.jboss.dmr.ModelNode;

public class OSGiModuleRemove
extends AbstractRemoveStepHandler
implements DescriptionProvider {
    static final OSGiModuleRemove INSTANCE = new OSGiModuleRemove();

    private OSGiModuleRemove() {
    }

    public ModelNode getModelDescription(Locale locale) {
        ModelNode node = new ModelNode();
        node.get("operation-name").set("remove");
        node.get("description").set(OSGiSubsystemProviders.getResourceBundle(locale).getString("module.remove"));
        node.get("request-properties").setEmptyObject();
        node.get("reply-properties").setEmptyObject();
        return node;
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String identifier = operation.get("address").asObject().get("module").asString();
        SubsystemState stateService = (SubsystemState)context.getServiceRegistry(true).getRequiredService(SubsystemState.SERVICE_NAME).getValue();
        SubsystemState.OSGiModule prevModule = stateService.removeModule(identifier);
        if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
            stateService.addModule(prevModule);
        }
    }
}

