/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.operations;

import java.security.AccessController;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.global.WriteAttributeHandlers;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.server.Services;
import org.jboss.as.server.mgmt.HttpManagementService;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.path.AbstractPathService;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.threads.JBossThreadFactory;

public class HttpManagementAttributeHandlers {
    public static final OperationStepHandler INSTANCE = new HttpManagementAttributeHandler();

    private HttpManagementAttributeHandlers() {
    }

    static void addService(ServiceTarget serviceTarget, ModelNode subModel, ServiceVerificationHandler handler) {
        String interfaceName = subModel.require("interface").asString();
        int port = HttpManagementAttributeHandlers.getIntValue(subModel, "port");
        int securePort = HttpManagementAttributeHandlers.getIntValue(subModel, "secure-port");
        String securityRealm = subModel.hasDefined("security-realm") ? subModel.get("security-realm").asString() : null;
        HttpManagementService service = new HttpManagementService();
        ServiceBuilder builder = serviceTarget.addService(HttpManagementService.SERVICE_NAME, (Service)service).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{interfaceName}), NetworkInterfaceBinding.class, service.getInterfaceInjector()).addListener((ServiceListener)handler).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.getModelControllerInjector()).addDependency(AbstractPathService.pathNameOf("jboss.server.temp.dir"), String.class, service.getTempDirInjector()).addInjection(service.getPortInjector(), (Object)port).addInjection(service.getSecurePortInjector(), (Object)securePort).addInjection(service.getExecutorServiceInjector(), (Object)Executors.newCachedThreadPool((ThreadFactory)new JBossThreadFactory(new ThreadGroup("HttpManagementService-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext())));
        if (securityRealm != null) {
            builder.addDependency(SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{securityRealm}), SecurityRealmService.class, service.getSecurityRealmInjector());
        } else {
            Logger.getLogger((String)"org.jboss.as").warn((Object)"No security realm defined for http management service, all access will be unrestricted.");
        }
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }

    static int getIntValue(ModelNode source, String name) {
        if (source.has(name)) {
            return source.require(name).asInt();
        }
        return -1;
    }

    static class HttpManagementAttributeHandler
    extends WriteAttributeHandlers.WriteAttributeOperationHandler {
        HttpManagementAttributeHandler() {
        }

        protected void modelChanged(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            final ModelNode subModel = resource.getModel();
            if (!newValue.equals(currentValue)) {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        context.removeService(HttpManagementService.SERVICE_NAME);
                        ServiceVerificationHandler handler = new ServiceVerificationHandler();
                        HttpManagementAttributeHandlers.addService(context.getServiceTarget(), subModel, handler);
                        context.addStep((OperationStepHandler)handler, OperationContext.Stage.VERIFY);
                        context.completeStep();
                    }
                }, OperationContext.Stage.RUNTIME);
            }
            context.completeStep();
        }
    }
}

