/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.classloading.internal;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;

public class ClassLoaderServiceImpl
implements ClassLoaderService {
    private final LinkedHashSet<ClassLoader> classLoadingClassLoaders = new LinkedHashSet();
    private final ClassLoader resourcesClassLoader;

    public ClassLoaderServiceImpl(Map configVales) {
        this(ClassLoaderServiceImpl.determineClassLoaders(configVales));
    }

    private ClassLoaderServiceImpl(ClassLoader ... classLoaders) {
        this(classLoaders[0], classLoaders[1], classLoaders[2], classLoaders[3]);
    }

    private static ClassLoader[] determineClassLoaders(Map configVales) {
        ClassLoader applicationClassLoader = (ClassLoader)configVales.get("hibernate.classLoader.application");
        ClassLoader resourcesClassLoader = (ClassLoader)configVales.get("hibernate.classLoader.resources");
        ClassLoader hibernateClassLoader = (ClassLoader)configVales.get("hibernate.classLoader.hibernate");
        ClassLoader environmentClassLoader = (ClassLoader)configVales.get("hibernate.classLoader.environment");
        if (hibernateClassLoader == null) {
            hibernateClassLoader = ClassLoaderServiceImpl.class.getClassLoader();
        }
        if (environmentClassLoader == null || applicationClassLoader == null) {
            ClassLoader sysClassLoader = ClassLoaderServiceImpl.locateSystemClassLoader();
            ClassLoader tccl = ClassLoaderServiceImpl.locateTCCL();
            if (environmentClassLoader == null) {
                ClassLoader classLoader = environmentClassLoader = sysClassLoader != null ? sysClassLoader : hibernateClassLoader;
            }
            if (applicationClassLoader == null) {
                ClassLoader classLoader = applicationClassLoader = tccl != null ? tccl : hibernateClassLoader;
            }
        }
        if (resourcesClassLoader == null) {
            resourcesClassLoader = applicationClassLoader;
        }
        return new ClassLoader[]{applicationClassLoader, resourcesClassLoader, hibernateClassLoader, environmentClassLoader};
    }

    private static ClassLoader locateSystemClassLoader() {
        try {
            return ClassLoader.getSystemClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ClassLoader locateTCCL() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception e) {
            return null;
        }
    }

    public ClassLoaderServiceImpl(ClassLoader classLoader) {
        this(classLoader, classLoader, classLoader, classLoader);
    }

    public ClassLoaderServiceImpl(ClassLoader applicationClassLoader, ClassLoader resourcesClassLoader, ClassLoader hibernateClassLoader, ClassLoader environmentClassLoader) {
        this.classLoadingClassLoaders.add(applicationClassLoader);
        this.classLoadingClassLoaders.add(hibernateClassLoader);
        this.classLoadingClassLoaders.add(environmentClassLoader);
        this.resourcesClassLoader = resourcesClassLoader;
    }

    @Override
    public <T> Class<T> classForName(String className) {
        for (ClassLoader classLoader : this.classLoadingClassLoaders) {
            try {
                return classLoader.loadClass(className);
            }
            catch (Exception ignore) {
            }
        }
        throw new ClassLoadingException("Unable to load class [" + className + "]");
    }

    @Override
    public URL locateResource(String name) {
        try {
            return new URL(name);
        }
        catch (Exception ignore) {
            try {
                return this.resourcesClassLoader.getResource(name);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @Override
    public InputStream locateResourceStream(String name) {
        try {
            return new URL(name).openStream();
        }
        catch (Exception ignore) {
            try {
                return this.resourcesClassLoader.getResourceAsStream(name);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    @Override
    public List<URL> locateResources(String name) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            Enumeration<URL> urlEnumeration = this.resourcesClassLoader.getResources(name);
            if (urlEnumeration != null && urlEnumeration.hasMoreElements()) {
                while (urlEnumeration.hasMoreElements()) {
                    urls.add(urlEnumeration.nextElement());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }
}

