/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.List;
import org.hibernate.FetchMode;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.binder.ToOneAttributeSource;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLManyToOneElement;

class ManyToOneAttributeSourceImpl
implements ToOneAttributeSource {
    private final XMLManyToOneElement manyToOneElement;
    private final LocalBindingContext bindingContext;
    private final List<RelationalValueSource> valueSources;

    ManyToOneAttributeSourceImpl(final XMLManyToOneElement manyToOneElement, LocalBindingContext bindingContext) {
        this.manyToOneElement = manyToOneElement;
        this.bindingContext = bindingContext;
        this.valueSources = Helper.buildValueSources(new Helper.ValueSourcesAdapter(){

            @Override
            public String getColumnAttribute() {
                return manyToOneElement.getColumn();
            }

            @Override
            public String getFormulaAttribute() {
                return manyToOneElement.getFormula();
            }

            @Override
            public List getColumnOrFormulaElements() {
                return manyToOneElement.getColumnOrFormula();
            }

            @Override
            public String getContainingTableName() {
                return null;
            }

            @Override
            public boolean isIncludedInInsertByDefault() {
                return manyToOneElement.isInsert();
            }

            @Override
            public boolean isIncludedInUpdateByDefault() {
                return manyToOneElement.isUpdate();
            }
        }, bindingContext);
    }

    @Override
    public String getName() {
        return this.manyToOneElement.getName();
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return Helper.TO_ONE_ATTRIBUTE_TYPE_SOURCE;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.manyToOneElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return this.manyToOneElement.isInsert();
    }

    @Override
    public boolean isUpdatable() {
        return this.manyToOneElement.isUpdate();
    }

    @Override
    public PropertyGeneration getGeneration() {
        return PropertyGeneration.NEVER;
    }

    @Override
    public boolean isLazy() {
        return false;
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.manyToOneElement.isOptimisticLock();
    }

    @Override
    public Iterable<CascadeStyle> getCascadeStyles() {
        return Helper.interpretCascadeStyles(this.manyToOneElement.getCascade(), this.bindingContext);
    }

    @Override
    public FetchMode getFetchMode() {
        return this.manyToOneElement.getFetch() == null ? FetchMode.DEFAULT : FetchMode.valueOf(this.manyToOneElement.getFetch().value());
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.MANY_TO_ONE;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return this.manyToOneElement.isInsert();
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return this.manyToOneElement.isUpdate();
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return !Helper.getBooleanValue(this.manyToOneElement.isNotNull(), false);
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return this.valueSources;
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.manyToOneElement.getMeta());
    }

    @Override
    public String getReferencedEntityName() {
        return this.manyToOneElement.getClazz() != null ? this.manyToOneElement.getClazz() : this.manyToOneElement.getEntityName();
    }

    @Override
    public String getReferencedEntityAttributeName() {
        return this.manyToOneElement.getPropertyRef();
    }
}

