/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.EntityMode;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.Value;
import org.hibernate.mapping.PropertyGeneration;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.binder.AttributeSource;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.ComponentAttributeSource;
import org.hibernate.metamodel.source.binder.ExplicitHibernateTypeSource;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.RelationalValueSource;
import org.hibernate.metamodel.source.binder.SingularAttributeNature;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.ManyToOneAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.PropertyAttributeSourceImpl;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLAnyElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLComponentElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLManyToManyElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLManyToOneElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLOneToManyElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLOneToOneElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLPropertyElement;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.XMLTuplizerElement;

public class ComponentAttributeSourceImpl
implements ComponentAttributeSource {
    private final XMLComponentElement componentElement;
    private final AttributeSourceContainer parentContainer;
    private final Value<Class<?>> componentClassReference;
    private final String path;

    public ComponentAttributeSourceImpl(XMLComponentElement componentElement, AttributeSourceContainer parentContainer, LocalBindingContext bindingContext) {
        this.componentElement = componentElement;
        this.parentContainer = parentContainer;
        this.componentClassReference = bindingContext.makeClassReference(bindingContext.qualifyClassName(componentElement.getClazz()));
        this.path = parentContainer.getPath() + '.' + componentElement.getName();
    }

    @Override
    public String getClassName() {
        return this.componentElement.getClazz();
    }

    @Override
    public Value<Class<?>> getClassReference() {
        return this.componentClassReference;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public LocalBindingContext getLocalBindingContext() {
        return this.parentContainer.getLocalBindingContext();
    }

    @Override
    public String getParentReferenceAttributeName() {
        return this.componentElement.getParent() == null ? null : this.componentElement.getParent().getName();
    }

    @Override
    public String getExplicitTuplizerClassName() {
        if (this.componentElement.getTuplizer() == null) {
            return null;
        }
        EntityMode entityMode = StringHelper.isEmpty(this.componentElement.getClazz()) ? EntityMode.MAP : EntityMode.POJO;
        for (XMLTuplizerElement tuplizerElement : this.componentElement.getTuplizer()) {
            if (entityMode != EntityMode.parse(tuplizerElement.getEntityMode())) continue;
            return tuplizerElement.getClazz();
        }
        return null;
    }

    @Override
    public Iterable<AttributeSource> attributeSources() {
        ArrayList<AttributeSource> attributeSources = new ArrayList<AttributeSource>();
        for (Object attributeElement : this.componentElement.getPropertyOrManyToOneOrOneToOne()) {
            if (XMLPropertyElement.class.isInstance(attributeElement)) {
                attributeSources.add(new PropertyAttributeSourceImpl((XMLPropertyElement)XMLPropertyElement.class.cast(attributeElement), this.getLocalBindingContext()));
                continue;
            }
            if (XMLComponentElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ComponentAttributeSourceImpl((XMLComponentElement)attributeElement, this, this.getLocalBindingContext()));
                continue;
            }
            if (XMLManyToOneElement.class.isInstance(attributeElement)) {
                attributeSources.add(new ManyToOneAttributeSourceImpl((XMLManyToOneElement)XMLManyToOneElement.class.cast(attributeElement), this.getLocalBindingContext()));
                continue;
            }
            if (!XMLOneToOneElement.class.isInstance(attributeElement) && !XMLAnyElement.class.isInstance(attributeElement) && !XMLOneToManyElement.class.isInstance(attributeElement) && !XMLManyToManyElement.class.isInstance(attributeElement)) continue;
        }
        return attributeSources;
    }

    @Override
    public boolean isVirtualAttribute() {
        return false;
    }

    @Override
    public SingularAttributeNature getNature() {
        return SingularAttributeNature.COMPONENT;
    }

    @Override
    public ExplicitHibernateTypeSource getTypeInformation() {
        return null;
    }

    @Override
    public String getName() {
        return this.componentElement.getName();
    }

    @Override
    public boolean isSingular() {
        return true;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.componentElement.getAccess();
    }

    @Override
    public boolean isInsertable() {
        return this.componentElement.isInsert();
    }

    @Override
    public boolean isUpdatable() {
        return this.componentElement.isUpdate();
    }

    @Override
    public PropertyGeneration getGeneration() {
        return null;
    }

    @Override
    public boolean isLazy() {
        return this.componentElement.isLazy();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.componentElement.isOptimisticLock();
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.componentElement.getMeta());
    }

    @Override
    public boolean areValuesIncludedInInsertByDefault() {
        return this.isInsertable();
    }

    @Override
    public boolean areValuesIncludedInUpdateByDefault() {
        return this.isUpdatable();
    }

    @Override
    public boolean areValuesNullableByDefault() {
        return true;
    }

    @Override
    public List<RelationalValueSource> relationalValueSources() {
        return null;
    }
}

