/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.hbm;

import org.hibernate.FetchMode;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.metamodel.source.LocalBindingContext;
import org.hibernate.metamodel.source.MappingException;
import org.hibernate.metamodel.source.binder.AttributeSourceContainer;
import org.hibernate.metamodel.source.binder.MetaAttributeSource;
import org.hibernate.metamodel.source.binder.PluralAttributeElementSource;
import org.hibernate.metamodel.source.binder.PluralAttributeKeySource;
import org.hibernate.metamodel.source.binder.PluralAttributeSource;
import org.hibernate.metamodel.source.hbm.BasicPluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.CompositePluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.Helper;
import org.hibernate.metamodel.source.hbm.ManyToManyPluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.OneToManyPluralAttributeElementSourceImpl;
import org.hibernate.metamodel.source.hbm.PluralAttributeKeySourceImpl;
import org.hibernate.metamodel.source.hbm.jaxb.mapping.PluralAttributeElement;

public abstract class AbstractPluralAttributeSourceImpl
implements PluralAttributeSource {
    private final PluralAttributeElement pluralAttributeElement;
    private final AttributeSourceContainer container;
    private final PluralAttributeKeySource keySource;
    private final PluralAttributeElementSource elementSource;

    protected AbstractPluralAttributeSourceImpl(PluralAttributeElement pluralAttributeElement, AttributeSourceContainer container) {
        this.pluralAttributeElement = pluralAttributeElement;
        this.container = container;
        this.keySource = new PluralAttributeKeySourceImpl(pluralAttributeElement.getKey(), container);
        this.elementSource = this.interpretElementType();
    }

    private PluralAttributeElementSource interpretElementType() {
        if (this.pluralAttributeElement.getElement() != null) {
            return new BasicPluralAttributeElementSourceImpl(this.pluralAttributeElement.getElement(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getCompositeElement() != null) {
            return new CompositePluralAttributeElementSourceImpl(this.pluralAttributeElement.getCompositeElement(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getOneToMany() != null) {
            return new OneToManyPluralAttributeElementSourceImpl(this.pluralAttributeElement.getOneToMany(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getManyToMany() != null) {
            return new ManyToManyPluralAttributeElementSourceImpl(this.pluralAttributeElement.getManyToMany(), this.container.getLocalBindingContext());
        }
        if (this.pluralAttributeElement.getManyToAny() != null) {
            throw new NotYetImplementedException("Support for many-to-any not yet implemented");
        }
        throw new MappingException("Unexpected collection element type : " + this.pluralAttributeElement.getName(), this.bindingContext().getOrigin());
    }

    public PluralAttributeElement getPluralAttributeElement() {
        return this.pluralAttributeElement;
    }

    protected AttributeSourceContainer container() {
        return this.container;
    }

    protected LocalBindingContext bindingContext() {
        return this.container().getLocalBindingContext();
    }

    @Override
    public PluralAttributeKeySource getKeySource() {
        return this.keySource;
    }

    @Override
    public PluralAttributeElementSource getElementSource() {
        return this.elementSource;
    }

    @Override
    public String getExplicitSchemaName() {
        return this.pluralAttributeElement.getSchema();
    }

    @Override
    public String getExplicitCatalogName() {
        return this.pluralAttributeElement.getCatalog();
    }

    @Override
    public String getExplicitCollectionTableName() {
        return this.pluralAttributeElement.getTable();
    }

    @Override
    public String getCollectionTableComment() {
        return this.pluralAttributeElement.getComment();
    }

    @Override
    public String getCollectionTableCheck() {
        return this.pluralAttributeElement.getCheck();
    }

    @Override
    public String getWhere() {
        return this.pluralAttributeElement.getWhere();
    }

    @Override
    public String getName() {
        return this.pluralAttributeElement.getName();
    }

    @Override
    public boolean isSingular() {
        return false;
    }

    @Override
    public String getPropertyAccessorName() {
        return this.pluralAttributeElement.getAccess();
    }

    @Override
    public boolean isIncludedInOptimisticLocking() {
        return this.pluralAttributeElement.isOptimisticLock();
    }

    @Override
    public boolean isInverse() {
        return this.pluralAttributeElement.isInverse();
    }

    @Override
    public Iterable<MetaAttributeSource> metaAttributes() {
        return Helper.buildMetaAttributeSources(this.pluralAttributeElement.getMeta());
    }

    @Override
    public Iterable<CascadeStyle> getCascadeStyles() {
        return Helper.interpretCascadeStyles(this.pluralAttributeElement.getCascade(), this.bindingContext());
    }

    @Override
    public FetchMode getFetchMode() {
        return this.pluralAttributeElement.getFetch() == null ? FetchMode.DEFAULT : FetchMode.valueOf(this.pluralAttributeElement.getFetch().value());
    }
}

