/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.source.annotations.xml.mocker;

import java.util.ArrayList;
import org.hibernate.metamodel.source.annotation.jaxb.XMLAccessType;
import org.hibernate.metamodel.source.annotation.jaxb.XMLOneToMany;
import org.hibernate.metamodel.source.annotations.xml.mocker.EntityMappingsMocker;
import org.hibernate.metamodel.source.annotations.xml.mocker.IndexBuilder;
import org.hibernate.metamodel.source.annotations.xml.mocker.MockHelper;
import org.hibernate.metamodel.source.annotations.xml.mocker.PropertyMocker;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;

class OneToManyMocker
extends PropertyMocker {
    private XMLOneToMany oneToMany;

    OneToManyMocker(IndexBuilder indexBuilder, ClassInfo classInfo, EntityMappingsMocker.Default defaults, XMLOneToMany oneToMany) {
        super(indexBuilder, classInfo, defaults);
        this.oneToMany = oneToMany;
    }

    @Override
    protected String getFieldName() {
        return this.oneToMany.getName();
    }

    @Override
    protected void processExtra() {
        ArrayList<AnnotationValue> annotationValueList = new ArrayList<AnnotationValue>();
        MockHelper.classValue("targetEntity", this.oneToMany.getTargetEntity(), annotationValueList, this.indexBuilder.getServiceRegistry());
        MockHelper.enumValue("fetch", FETCH_TYPE, this.oneToMany.getFetch(), annotationValueList);
        MockHelper.stringValue("mappedBy", this.oneToMany.getMappedBy(), annotationValueList);
        MockHelper.booleanValue("orphanRemoval", this.oneToMany.isOrphanRemoval(), annotationValueList);
        MockHelper.cascadeValue("cascade", this.oneToMany.getCascade(), this.isDefaultCascadePersist(), annotationValueList);
        this.create(ONE_TO_MANY, this.getTarget(), annotationValueList);
        this.parserAttributeOverrides(this.oneToMany.getMapKeyAttributeOverride(), this.getTarget());
        this.parserMapKeyJoinColumnList(this.oneToMany.getMapKeyJoinColumn(), this.getTarget());
        this.parserMapKey(this.oneToMany.getMapKey(), this.getTarget());
        this.parserMapKeyColumn(this.oneToMany.getMapKeyColumn(), this.getTarget());
        this.parserMapKeyClass(this.oneToMany.getMapKeyClass(), this.getTarget());
        this.parserMapKeyTemporal(this.oneToMany.getMapKeyTemporal(), this.getTarget());
        this.parserMapKeyEnumerated(this.oneToMany.getMapKeyEnumerated(), this.getTarget());
        this.parserJoinColumnList(this.oneToMany.getJoinColumn(), this.getTarget());
        this.parserOrderColumn(this.oneToMany.getOrderColumn(), this.getTarget());
        this.parserJoinTable(this.oneToMany.getJoinTable(), this.getTarget());
        if (this.oneToMany.getOrderBy() != null) {
            this.create(ORDER_BY, this.getTarget(), MockHelper.stringValueArray("value", this.oneToMany.getOrderBy()));
        }
    }

    @Override
    protected XMLAccessType getAccessType() {
        return this.oneToMany.getAccess();
    }

    @Override
    protected void setAccessType(XMLAccessType accessType) {
        this.oneToMany.setAccess(accessType);
    }
}

