/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.security;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.jboss.as.web.security.JBossGenericPrincipal;
import org.jboss.as.web.security.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.jboss.RunAsIdentityMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityUtil;

public class SecurityContextAssociationValve
extends ValveBase {
    private static Logger log = Logger.getLogger(SecurityContextAssociationValve.class);
    private JBossWebMetaData metaData;

    public SecurityContextAssociationValve(JBossWebMetaData metaData) {
        this.metaData = metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean trace = log.isTraceEnabled();
        Session session = null;
        Principal caller = request.getPrincipal();
        JBossGenericPrincipal principal = null;
        HttpSession hsession = request.getSession(false);
        if (trace) {
            log.trace((Object)("Begin invoke, caller=" + caller));
        }
        boolean createdSecurityContext = false;
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc == null) {
            createdSecurityContext = true;
            String securityDomain = SecurityUtil.unprefixSecurityDomain((String)this.metaData.getSecurityDomain());
            if (securityDomain == null) {
                securityDomain = "jboss-web-policy";
            }
            sc = SecurityActions.createSecurityContext(securityDomain);
            SecurityActions.setSecurityContextOnAssociation(sc);
        }
        try {
            Wrapper servlet = null;
            try {
                Manager manager;
                servlet = request.getWrapper();
                if (servlet != null) {
                    String name = servlet.getName();
                    RunAsIdentityMetaData identity = this.metaData.getRunAsIdentity(name);
                    RunAsIdentity runAsIdentity = null;
                    if (identity != null) {
                        if (trace) {
                            log.trace((Object)(name + ", runAs: " + identity));
                        }
                        runAsIdentity = new RunAsIdentity(identity.getRoleName(), identity.getPrincipalName(), identity.getRunAsRoles());
                    }
                    SecurityActions.pushRunAsIdentity(runAsIdentity);
                }
                if ((manager = this.container.getManager()) != null && hsession != null) {
                    try {
                        session = manager.findSession(hsession.getId());
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                if (caller == null || !(caller instanceof JBossGenericPrincipal)) {
                    if (session != null) {
                        principal = (JBossGenericPrincipal)((Object)session.getPrincipal());
                    }
                } else {
                    principal = (JBossGenericPrincipal)((Object)caller);
                }
                if (principal != null) {
                    if (trace) {
                        log.trace((Object)"Restoring principal info from cache");
                    }
                    if (createdSecurityContext) {
                        sc.getUtil().createSubjectInfo(principal.getUserPrincipal(), principal.getCredentials(), principal.getSubject());
                    }
                }
            }
            catch (Throwable e) {
                log.debug((Object)"Failed to determine servlet", e);
            }
            this.getNext().invoke(request, response);
            if (servlet != null) {
                SecurityActions.popRunAsIdentity();
            }
        }
        finally {
            if (trace) {
                log.trace((Object)("End invoke, caller=" + caller));
            }
            SecurityActions.clearSecurityContext();
        }
    }
}

