/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import java.util.List;
import java.util.Locale;
import java.util.concurrent.Executor;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.threads.ThreadsServices;
import org.jboss.as.web.WebConnectorService;
import org.jboss.as.web.WebServer;
import org.jboss.as.web.WebSubsystemDescriptions;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

class WebConnectorAdd
extends AbstractAddStepHandler
implements DescriptionProvider {
    static final String OPERATION_NAME = "add";
    static final WebConnectorAdd INSTANCE = new WebConnectorAdd();

    static ModelNode getRecreateOperation(ModelNode address, ModelNode existing) {
        ModelNode op = Util.getEmptyOperation((String)OPERATION_NAME, (ModelNode)address);
        op.get("protocol").set(existing.get("protocol"));
        op.get("socket-binding").set(existing.get("socket-binding"));
        if (existing.hasDefined("scheme")) {
            op.get("scheme").set(existing.get("scheme").asString());
        }
        if (existing.hasDefined("secure")) {
            op.get("secure").set(existing.get("secure").asBoolean());
        }
        if (existing.hasDefined("enabled")) {
            op.get("enabled").set(existing.get("enabled").asBoolean());
        }
        if (existing.hasDefined("enable-lookups")) {
            op.get("enable-lookups").set(existing.get("enable-lookups").asBoolean());
        }
        if (existing.hasDefined("executor")) {
            op.get("executor").set(existing.get("executor").asString());
        }
        if (existing.hasDefined("proxy-name")) {
            op.get("proxy-name").set(existing.get("proxy-name").asString());
        }
        if (existing.hasDefined("proxy-port")) {
            op.get("proxy-port").set(existing.get("proxy-port").asInt());
        }
        if (existing.hasDefined("redirect-port")) {
            op.get("redirect-port").set(existing.get("redirect-port").asInt());
        }
        if (existing.hasDefined("max-post-size")) {
            op.get("max-post-size").set(existing.get("max-post-size").asInt());
        }
        if (existing.hasDefined("max-save-post-size")) {
            op.get("max-save-post-size").set(existing.get("max-save-post-size").asInt());
        }
        if (existing.hasDefined("max-connections")) {
            op.get("max-connections").set(existing.get("max-connections").asInt());
        }
        op.get("virtual-server").set(existing.get("virtual-server"));
        op.get("ssl").set(existing.get("ssl"));
        return op;
    }

    private WebConnectorAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode subModel) {
        subModel.get("protocol").set(operation.get("protocol"));
        subModel.get("socket-binding").set(operation.get("socket-binding"));
        if (operation.hasDefined("scheme")) {
            subModel.get("scheme").set(operation.get("scheme"));
        }
        if (operation.hasDefined("secure")) {
            subModel.get("secure").set(operation.get("secure").asBoolean());
        }
        if (operation.hasDefined("enabled")) {
            subModel.get("enabled").set(operation.get("enabled").asBoolean());
        }
        if (operation.hasDefined("enable-lookups")) {
            subModel.get("enable-lookups").set(operation.get("enable-lookups").asBoolean());
        }
        if (operation.hasDefined("executor")) {
            subModel.get("executor").set(operation.get("executor").asString());
        }
        if (operation.hasDefined("proxy-name")) {
            subModel.get("proxy-name").set(operation.get("proxy-name").asString());
        }
        if (operation.hasDefined("proxy-port")) {
            subModel.get("proxy-port").set(operation.get("proxy-port").asInt());
        }
        if (operation.hasDefined("redirect-port")) {
            subModel.get("redirect-port").set(operation.get("redirect-port").asInt());
        }
        if (operation.hasDefined("max-post-size")) {
            subModel.get("max-post-size").set(operation.get("max-post-size").asInt());
        }
        if (operation.hasDefined("max-save-post-size")) {
            subModel.get("max-save-post-size").set(operation.get("max-save-post-size").asInt());
        }
        if (operation.hasDefined("max-connections")) {
            subModel.get("max-connections").set(operation.get("max-connections").asInt());
        }
        subModel.get("virtual-server").set(operation.get("virtual-server"));
        subModel.get("ssl").set(operation.get("ssl"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String name = address.getLastElement().getValue();
        String bindingRef = operation.require("socket-binding").asString();
        boolean enabled = operation.hasDefined("enabled") ? operation.get("enabled").asBoolean() : true;
        WebConnectorService service = new WebConnectorService(operation.require("protocol").asString(), operation.get("scheme").asString());
        if (operation.hasDefined("secure")) {
            service.setSecure(operation.get("secure").asBoolean());
        }
        if (operation.hasDefined("enable-lookups")) {
            service.setEnableLookups(operation.get("enable-lookups").asBoolean());
        }
        if (operation.hasDefined("proxy-name")) {
            service.setProxyName(operation.get("proxy-name").asString());
        }
        if (operation.hasDefined("proxy-port")) {
            service.setProxyPort(operation.get("proxy-port").asInt());
        }
        if (operation.hasDefined("redirect-port")) {
            service.setRedirectPort(operation.get("redirect-port").asInt());
        }
        if (operation.hasDefined("max-post-size")) {
            service.setMaxPostSize(operation.get("max-post-size").asInt());
        }
        if (operation.hasDefined("max-save-post-size")) {
            service.setMaxSavePostSize(operation.get("max-save-post-size").asInt());
        }
        if (operation.hasDefined("max-connections")) {
            service.setMaxConnections(operation.get("max-connections").asInt());
        }
        if (operation.hasDefined("virtual-server")) {
            service.setVirtualServers(operation.get("virtual-server").clone());
        }
        if (operation.hasDefined("ssl")) {
            service.setSsl(operation.get("ssl").clone());
        }
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(WebSubsystemServices.JBOSS_WEB_CONNECTOR.append(new String[]{name}), (Service)service).addDependency(WebSubsystemServices.JBOSS_WEB, WebServer.class, service.getServer()).addDependency(SocketBinding.JBOSS_BINDING_NAME.append(new String[]{bindingRef}), SocketBinding.class, service.getBinding());
        if (operation.hasDefined("executor")) {
            String executorRef = operation.get("executor").asString();
            serviceBuilder.addDependency(ThreadsServices.executorName((String)executorRef), Executor.class, service.getExecutor());
        }
        serviceBuilder.setInitialMode(enabled ? ServiceController.Mode.ACTIVE : ServiceController.Mode.NEVER);
        if (enabled) {
            serviceBuilder.addListener((ServiceListener)verificationHandler);
        }
        newControllers.add(serviceBuilder.install());
    }

    public ModelNode getModelDescription(Locale locale) {
        return WebSubsystemDescriptions.getConnectorAdd(locale);
    }
}

