/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.util.Properties;
import javax.naming.directory.InitialDirContext;
import org.jboss.as.domain.management.connections.ConnectionManager;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class LdapConnectionManagerService
implements Service<LdapConnectionManagerService>,
ConnectionManager {
    public static final ServiceName BASE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"server", "controller", "management", "connection_manager"});
    private static final String DEFAULT_INITIAL_CONTEXT = "com.sun.jndi.ldap.LdapCtxFactory";
    private Properties connectionOnlyProperties;
    private Properties fullProperties;
    private final ModelNode ldapConnection;

    public LdapConnectionManagerService(ModelNode ldapConnection) {
        this.ldapConnection = ldapConnection;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.connectionOnlyProperties = new Properties();
        this.connectionOnlyProperties.put("java.naming.security.authentication", "simple");
        String initialContextFactory = DEFAULT_INITIAL_CONTEXT;
        if (this.ldapConnection.has("initial-context-factory")) {
            initialContextFactory = this.ldapConnection.require("initial-context-factory").asString();
        }
        this.connectionOnlyProperties.put("java.naming.factory.initial", initialContextFactory);
        String url = this.ldapConnection.require("url").asString();
        this.connectionOnlyProperties.put("java.naming.provider.url", url);
        this.fullProperties = (Properties)this.connectionOnlyProperties.clone();
        String searchDN = this.ldapConnection.require("search-dn").asString();
        String searchCredential = this.ldapConnection.require("search-credential").asString();
        this.fullProperties.put("java.naming.security.principal", searchDN);
        this.fullProperties.put("java.naming.security.credentials", searchCredential);
    }

    public synchronized void stop(StopContext context) {
        this.connectionOnlyProperties = null;
        this.fullProperties = null;
    }

    public synchronized LdapConnectionManagerService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public Object getConnection() throws Exception {
        return this.getConnection(this.fullProperties);
    }

    @Override
    public Object getConnection(String principal, String credential) throws Exception {
        Properties connectionProperties = (Properties)this.connectionOnlyProperties.clone();
        connectionProperties.put("java.naming.security.principal", principal);
        connectionProperties.put("java.naming.security.credentials", credential);
        return this.getConnection(connectionProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getConnection(Properties properties) throws Exception {
        ClassLoader original = null;
        try {
            original = Thread.currentThread().getContextClassLoader();
            if (original != null) {
                Thread.currentThread().setContextClassLoader(null);
            }
            InitialDirContext initialDirContext = new InitialDirContext(properties);
            return initialDirContext;
        }
        finally {
            if (original != null) {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
    }
}

