/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.SubDeploymentMarker;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.metadata.ear.jboss.JBossAppMetaData;
import org.jboss.metadata.ear.spec.Ear5xMetaData;
import org.jboss.metadata.ear.spec.EarMetaData;
import org.jboss.metadata.ear.spec.ModuleMetaData;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;

public class EarStructureProcessor
implements DeploymentUnitProcessor {
    private static final String JAR_EXTENSION = ".jar";
    private static final String WAR_EXTENSION = ".war";
    private static final String SAR_EXTENSION = ".sar";
    private static final List<String> CHILD_ARCHIVE_EXTENSIONS = new ArrayList<String>();
    private static final SuffixMatchFilter CHILD_ARCHIVE_FILTER;
    private static final String DEFAULT_LIB_DIR = "lib";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        String xmlLibDirName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType(DeploymentType.EAR, deploymentUnit)) {
            return;
        }
        ResourceRoot resourceRoot = (ResourceRoot)phaseContext.getDeploymentUnit().getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        VirtualFile virtualFile = resourceRoot.getRoot();
        resourceRoot.putAttachment(org.jboss.as.server.deployment.Attachments.INDEX_RESOURCE_ROOT, (Object)false);
        ModuleRootMarker.mark((ResourceRoot)resourceRoot, (boolean)false);
        String libDirName = DEFAULT_LIB_DIR;
        JBossAppMetaData appMetaData = (JBossAppMetaData)deploymentUnit.getAttachment(Attachments.JBOSS_APP_METADATA);
        EarMetaData earMetaData = (EarMetaData)deploymentUnit.getAttachment(Attachments.EAR_METADATA);
        if (appMetaData != null) {
            xmlLibDirName = appMetaData.getLibraryDirectory();
            if (xmlLibDirName != null) {
                libDirName = xmlLibDirName;
            }
        } else if (earMetaData != null && earMetaData instanceof Ear5xMetaData && (xmlLibDirName = ((Ear5xMetaData)Ear5xMetaData.class.cast(earMetaData)).getLibraryDirectory()) != null) {
            libDirName = xmlLibDirName;
        }
        try {
            VirtualFile libDir;
            if (!libDirName.isEmpty()) {
                libDir = virtualFile.getChild(libDirName);
                if (libDir.exists()) {
                    List libArchives = libDir.getChildren((VirtualFileFilter)CHILD_ARCHIVE_FILTER);
                    for (VirtualFile child : libArchives) {
                        Closeable closable = child.isFile() ? EarStructureProcessor.mount(child, false) : null;
                        MountHandle mountHandle = new MountHandle(closable);
                        ResourceRoot childResource = new ResourceRoot(child, mountHandle);
                        if (!child.getName().toLowerCase().endsWith(JAR_EXTENSION)) continue;
                        ModuleRootMarker.mark((ResourceRoot)childResource);
                        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS, (Object)childResource);
                    }
                }
            } else {
                libDir = null;
            }
            ArrayList childArchives = new ArrayList(virtualFile.getChildren((VirtualFileFilter)new SuffixMatchFilter(CHILD_ARCHIVE_EXTENSIONS, new VisitorAttributes(){

                public boolean isLeavesOnly() {
                    return false;
                }

                public boolean isRecurse(VirtualFile file) {
                    if (file.equals(libDir)) {
                        return false;
                    }
                    for (String suffix : CHILD_ARCHIVE_EXTENSIONS) {
                        if (!file.getName().endsWith(suffix)) continue;
                        return false;
                    }
                    return true;
                }
            })));
            if (earMetaData == null) {
                for (VirtualFile child : childArchives) {
                    boolean isWarFile = child.getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION);
                    this.createResourceRoot(deploymentUnit, child, isWarFile, isWarFile);
                }
            } else {
                HashSet<VirtualFile> subDeploymentFiles = new HashSet<VirtualFile>();
                for (ModuleMetaData module : earMetaData.getModules()) {
                    VirtualFile moduleFile = virtualFile.getChild(module.getFileName());
                    if (!moduleFile.exists()) {
                        throw new DeploymentUnitProcessingException("Unable to process modules in application.xml for EAR [" + virtualFile + "], module file " + module.getFileName() + " not found");
                    }
                    subDeploymentFiles.add(moduleFile);
                    boolean explodeDuringMount = module.getType() == ModuleMetaData.ModuleType.Web;
                    ResourceRoot childResource = this.createResourceRoot(deploymentUnit, moduleFile, true, explodeDuringMount);
                    childResource.putAttachment(Attachments.MODULE_META_DATA, (Object)module);
                }
                for (VirtualFile child : childArchives) {
                    String fileName;
                    if (subDeploymentFiles.contains(child) || !(fileName = child.getName().toLowerCase(Locale.ENGLISH)).endsWith(SAR_EXTENSION) && !fileName.endsWith(JAR_EXTENSION)) continue;
                    this.createResourceRoot(deploymentUnit, child, false, false);
                }
            }
        }
        catch (IOException e) {
            throw new DeploymentUnitProcessingException("Failed to process children for EAR [" + virtualFile + "]", (Throwable)e);
        }
    }

    private static Closeable mount(VirtualFile moduleFile, boolean explode) throws IOException {
        return explode ? VFS.mountZipExpanded((VirtualFile)moduleFile, (VirtualFile)moduleFile, (TempFileProvider)TempFileProviderService.provider()) : VFS.mountZip((VirtualFile)moduleFile, (VirtualFile)moduleFile, (TempFileProvider)TempFileProviderService.provider());
    }

    private ResourceRoot createResourceRoot(DeploymentUnit deploymentUnit, VirtualFile file, boolean markAsSubDeployment, boolean explodeDuringMount) throws IOException {
        boolean war = file.getName().toLowerCase(Locale.ENGLISH).endsWith(WAR_EXTENSION);
        Closeable closable = file.isFile() ? EarStructureProcessor.mount(file, explodeDuringMount) : null;
        MountHandle mountHandle = new MountHandle(closable);
        ResourceRoot resourceRoot = new ResourceRoot(file, mountHandle);
        deploymentUnit.addToAttachmentList(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS, (Object)resourceRoot);
        if (markAsSubDeployment) {
            SubDeploymentMarker.mark((ResourceRoot)resourceRoot);
        }
        if (war) {
            resourceRoot.putAttachment(org.jboss.as.server.deployment.Attachments.INDEX_RESOURCE_ROOT, (Object)false);
        }
        return resourceRoot;
    }

    public void undeploy(DeploymentUnit context) {
        List children = (List)context.removeAttachment(org.jboss.as.server.deployment.Attachments.RESOURCE_ROOTS);
        if (children != null) {
            for (ResourceRoot childRoot : children) {
                VFSUtils.safeClose((Closeable)childRoot.getMountHandle());
            }
        }
    }

    static {
        CHILD_ARCHIVE_EXTENSIONS.add(JAR_EXTENSION);
        CHILD_ARCHIVE_EXTENSIONS.add(WAR_EXTENSION);
        CHILD_ARCHIVE_EXTENSIONS.add(SAR_EXTENSION);
        CHILD_ARCHIVE_FILTER = new SuffixMatchFilter(CHILD_ARCHIVE_EXTENSIONS, new VisitorAttributes(){

            public boolean isLeavesOnly() {
                return false;
            }
        });
    }
}

