/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Random;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.ServiceOpenException;
import org.jboss.remoting3.remote.PendingChannel;
import org.jboss.remoting3.remote.Protocol;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionChannel;
import org.jboss.remoting3.remote.UnlockedReadIntIndexHashMap;
import org.jboss.remoting3.security.InetAddressPrincipal;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.remoting3.spi.AbstractHandleableCloseable;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.xnio.Cancellable;
import org.xnio.IoUtils;
import org.xnio.OptionMap;
import org.xnio.Pooled;
import org.xnio.Result;
import org.xnio.channels.Channels;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.WritableMessageChannel;

final class RemoteConnectionHandler
extends AbstractHandleableCloseable<ConnectionHandler>
implements ConnectionHandler {
    static final int LENGTH_PLACEHOLDER = 0;
    private final ConnectionHandlerContext connectionContext;
    private final RemoteConnection remoteConnection;
    private final Random random = new Random();
    private final UnlockedReadIntIndexHashMap<RemoteConnectionChannel> channels = new UnlockedReadIntIndexHashMap<RemoteConnectionChannel>(RemoteConnectionChannel.INDEXER);
    private final UnlockedReadIntIndexHashMap<PendingChannel> pendingChannels = new UnlockedReadIntIndexHashMap<PendingChannel>(PendingChannel.INDEXER);
    private final Collection<Principal> principals;
    private int channelCount = 50;
    private static final ThreadLocal<RemoteConnectionHandler> current = new ThreadLocal();

    RemoteConnectionHandler(ConnectionHandlerContext connectionContext, RemoteConnection remoteConnection, String authorizationId) {
        super(remoteConnection.getExecutor());
        ConnectedMessageChannel channel;
        InetSocketAddress address;
        this.connectionContext = connectionContext;
        this.remoteConnection = remoteConnection;
        SslChannel sslChannel = remoteConnection.getSslChannel();
        LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
        if (sslChannel != null) {
            try {
                Principal peerPrincipal = sslChannel.getSslSession().getPeerPrincipal();
                principals.add(peerPrincipal);
            }
            catch (SSLPeerUnverifiedException ignored) {
                // empty catch block
            }
        }
        if (authorizationId != null) {
            principals.add(new UserPrincipal(authorizationId));
        }
        if ((address = (InetSocketAddress)(channel = remoteConnection.getChannel()).getPeerAddress(InetSocketAddress.class)) != null) {
            principals.add(new InetAddressPrincipal(address.getAddress()));
        }
        this.principals = Collections.unmodifiableSet(principals);
    }

    RemoteConnectionHandler(ConnectionHandlerContext connectionContext, RemoteConnection remoteConnection) {
        this(connectionContext, remoteConnection, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Cancellable open(String serviceType, Result<Channel> result, OptionMap optionMap) {
        byte[] serviceTypeBytes = serviceType.getBytes(Protocol.UTF_8);
        int serviceTypeLength = serviceTypeBytes.length;
        if (serviceTypeLength > 255) {
            result.setException((IOException)new ServiceOpenException("Service type name is too long"));
            return IoUtils.nullCancellable();
        }
        OptionMap connectionOptionMap = this.remoteConnection.getOptionMap();
        int outboundWindowSize = optionMap.get(RemotingOptions.TRANSMIT_WINDOW_SIZE, connectionOptionMap.get(RemotingOptions.TRANSMIT_WINDOW_SIZE, 16384));
        int inboundWindowSize = optionMap.get(RemotingOptions.RECEIVE_WINDOW_SIZE, connectionOptionMap.get(RemotingOptions.RECEIVE_WINDOW_SIZE, 16384));
        int outboundMessageCount = optionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGES, connectionOptionMap.get(RemotingOptions.MAX_OUTBOUND_MESSAGES, 4));
        int inboundMessageCount = optionMap.get(RemotingOptions.MAX_INBOUND_MESSAGES, connectionOptionMap.get(RemotingOptions.MAX_INBOUND_MESSAGES, 4));
        UnlockedReadIntIndexHashMap<PendingChannel> pendingChannels = this.pendingChannels;
        RemoteConnection remoteConnection = this.remoteConnection;
        synchronized (remoteConnection) {
            int id;
            int channelCount;
            while ((channelCount = this.channelCount) == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    result.setException((IOException)new InterruptedIOException("Interrupted while waiting to write message"));
                    return IoUtils.nullCancellable();
                }
            }
            Random random = this.random;
            while (pendingChannels.containsKey(id = random.nextInt() | Integer.MIN_VALUE)) {
            }
            PendingChannel pendingChannel = new PendingChannel(id, outboundWindowSize, inboundWindowSize, outboundMessageCount, inboundMessageCount, result);
            pendingChannels.put(pendingChannel);
            this.channelCount = channelCount - 1;
            Pooled<ByteBuffer> pooled = this.remoteConnection.allocate();
            try {
                ByteBuffer buffer = (ByteBuffer)pooled.getResource();
                ConnectedMessageChannel channel = this.remoteConnection.getChannel();
                buffer.put((byte)16);
                buffer.putInt(id);
                ProtocolUtils.writeBytes(buffer, 1, serviceTypeBytes);
                ProtocolUtils.writeInt(buffer, 128, inboundWindowSize);
                ProtocolUtils.writeShort(buffer, 129, inboundMessageCount);
                buffer.put((byte)0);
                buffer.flip();
                try {
                    Channels.sendBlocking((WritableMessageChannel)channel, (ByteBuffer)buffer);
                }
                catch (IOException e) {
                    result.setException(e);
                    pendingChannels.remove(id);
                    Cancellable cancellable = IoUtils.nullCancellable();
                    pooled.free();
                    return cancellable;
                }
                Cancellable cancellable = IoUtils.nullCancellable();
                return cancellable;
            }
            finally {
                pooled.free();
            }
        }
    }

    @Override
    public Collection<Principal> getPrincipals() {
        return this.principals;
    }

    @Override
    protected void closeAction() throws IOException {
        if (this.remoteConnection.handleOutboundCloseRequest()) {
            this.closeAllChannels();
        }
        this.closeComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAllChannels() {
        RemoteConnection remoteConnection = this.remoteConnection;
        synchronized (remoteConnection) {
            ClosedChannelException exception = new ClosedChannelException();
            for (PendingChannel pendingChannel : this.pendingChannels) {
                pendingChannel.getResult().setException((IOException)exception);
            }
            this.pendingChannels.clear();
            for (RemoteConnectionChannel channel : this.channels) {
                channel.handleRemoteClose();
            }
            this.channels.clear();
        }
    }

    void handleClose() {
        this.remoteConnection.handleChannelClose();
        this.closeAllChannels();
        this.connectionContext.remoteClosed();
    }

    ConnectionHandlerContext getConnectionContext() {
        return this.connectionContext;
    }

    Random getRandom() {
        return this.random;
    }

    RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    static RemoteConnectionHandler getCurrent() {
        return current.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteConnectionHandler setCurrent(RemoteConnectionHandler newCurrent) {
        ThreadLocal<RemoteConnectionHandler> current = RemoteConnectionHandler.current;
        try {
            RemoteConnectionHandler remoteConnectionHandler = current.get();
            return remoteConnectionHandler;
        }
        finally {
            current.set(newCurrent);
        }
    }

    void addChannel(RemoteConnectionChannel channel) {
        RemoteConnectionChannel existing = this.channels.putIfAbsent(channel);
        if (existing != null) {
            channel.getConnection().handleException(new IOException("Attempted to add an already-existing channel"));
        }
    }

    RemoteConnectionChannel getChannel(int id) {
        return this.channels.get(id);
    }

    PendingChannel removePendingChannel(int id) {
        return this.pendingChannels.remove(id);
    }

    void putChannel(RemoteConnectionChannel channel) {
        this.channels.put(channel);
    }
}

