/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.weld.ejb;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.ejb.NoSuchEJBException;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ee.component.ComponentViewInstance;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponent;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.as.weld.ejb.EjbDescriptorImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.weld.ejb.api.SessionObjectReference;
import org.jboss.weld.ejb.spi.BusinessInterfaceDescriptor;

public class StatefulSessionObjectReferenceImpl
implements SessionObjectReference,
Serializable {
    private volatile boolean removed = false;
    private final Map<String, ServiceName> viewServices;
    private transient StatefulSessionComponent ejbComponent;
    private final ServiceName createServiceName;
    private final Serializable id;

    public StatefulSessionObjectReferenceImpl(EjbDescriptorImpl<?> descriptor) {
        this.createServiceName = descriptor.getCreateServiceName();
        HashMap<String, ServiceName> viewServices = new HashMap<String, ServiceName>();
        HashMap<String, Class> views = new HashMap<String, Class>();
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : descriptor.getRemoteBusinessInterfaces()) {
            views.put(businessInterfaceDescriptor.getInterface().getName(), businessInterfaceDescriptor.getInterface());
        }
        for (BusinessInterfaceDescriptor<?> businessInterfaceDescriptor : descriptor.getLocalBusinessInterfaces()) {
            views.put(businessInterfaceDescriptor.getInterface().getName(), businessInterfaceDescriptor.getInterface());
        }
        for (Map.Entry entry : descriptor.getViewServices().entrySet()) {
            Class viewClass = (Class)entry.getKey();
            if (viewClass == null) continue;
            HashSet<Class> seen = new HashSet<Class>();
            HashSet toProcess = new HashSet();
            toProcess.add(viewClass);
            while (!toProcess.isEmpty()) {
                Iterator it = toProcess.iterator();
                Class clazz = (Class)it.next();
                it.remove();
                seen.add(clazz);
                viewServices.put(clazz.getName(), (ServiceName)entry.getValue());
                Class superclass = clazz.getSuperclass();
                if (superclass != Object.class && superclass != null && !seen.contains(superclass)) {
                    toProcess.add(superclass);
                }
                for (Class<?> iface : clazz.getInterfaces()) {
                    if (seen.contains(iface)) continue;
                    toProcess.add(iface);
                }
            }
        }
        this.id = this.getComponent().createSession();
        this.viewServices = viewServices;
    }

    public synchronized <S> S getBusinessObject(Class<S> businessInterfaceType) {
        if (this.isRemoved()) {
            throw new NoSuchEJBException("Bean has been removed");
        }
        if (this.viewServices.containsKey(businessInterfaceType.getName())) {
            ServiceController serviceController = CurrentServiceContainer.getServiceContainer().getRequiredService(this.viewServices.get(businessInterfaceType.getName()));
            ComponentView view = (ComponentView)serviceController.getValue();
            ComponentViewInstance instance = view.createInstance(Collections.singletonMap(StatefulSessionComponent.SESSION_ATTACH_KEY, this.id));
            return (S)instance.createProxy();
        }
        throw new IllegalStateException("View of type " + businessInterfaceType + " not found on bean " + this.getComponent());
    }

    public void remove() {
        if (!this.isRemoved()) {
            this.getComponent().removeSession(this.id);
            this.removed = true;
        }
    }

    public boolean isRemoved() {
        if (!this.removed) {
            try {
                this.getComponent().getCache().get(this.id);
                return false;
            }
            catch (NoSuchEJBException e) {
                return true;
            }
        }
        return true;
    }

    private StatefulSessionComponent getComponent() {
        if (this.ejbComponent == null) {
            ServiceController controller = CurrentServiceContainer.getServiceContainer().getRequiredService(this.createServiceName);
            this.ejbComponent = (StatefulSessionComponent)controller.getValue();
        }
        return this.ejbComponent;
    }
}

