/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.Identifier;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.SequenceAcknowledgement;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapFaultFactory
implements BindingFaultFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapFaultFactory.class);
    private static final String WS_RM_PACKAGE = PackageUtils.getPackageName(SequenceType.class);
    private SoapVersion version;

    public SoapFaultFactory(Binding binding) {
        this.version = ((SoapBinding)binding).getSoapVersion();
    }

    public Fault createFault(SequenceFault sf) {
        Fault f = null;
        if (this.version == Soap11.getInstance()) {
            f = this.createSoap11Fault(sf);
            f.initCause((Throwable)sf);
        } else {
            f = this.createSoap12Fault(sf);
        }
        return f;
    }

    Fault createSoap11Fault(SequenceFault sf) {
        SoapFault fault = new SoapFault(sf.getReason(), sf.isSender() ? this.version.getSender() : this.version.getReceiver());
        fault.setSubCode(sf.getSubCode());
        return fault;
    }

    Fault createSoap12Fault(SequenceFault sf) {
        SoapFault fault = (SoapFault)this.createSoap11Fault(sf);
        Object detail = sf.getDetail();
        if (null == detail) {
            return fault;
        }
        try {
            this.setDetail(fault, detail);
        }
        catch (Exception ex) {
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"MARSHAL_FAULT_DETAIL_EXC", (Throwable)ex);
            ex.printStackTrace();
        }
        return fault;
    }

    void setDetail(SoapFault fault, Object detail) throws Exception {
        Document doc = DOMUtils.createDocument();
        Element elem = null;
        JAXBContext ctx = JAXBContext.newInstance((String)WS_RM_PACKAGE, (ClassLoader)SequenceAcknowledgement.class.getClassLoader());
        Marshaller m = ctx.createMarshaller();
        if (RMConstants.getInvalidAcknowledgmentFaultCode().equals(fault.getSubCode())) {
            SequenceAcknowledgement ack = (SequenceAcknowledgement)detail;
            m.marshal((Object)ack, (Node)doc);
        } else if (!RMConstants.getCreateSequenceRefusedFaultCode().equals(fault.getSubCode())) {
            Identifier id = (Identifier)detail;
            m.marshal((Object)id, (Node)doc);
        }
        elem = (Element)doc.getFirstChild();
        fault.setDetail(elem);
    }

    public String toString(Fault f) {
        SoapFault sf = (SoapFault)f;
        Message msg = new Message("SEQ_FAULT_MSG", LOG, new Object[]{sf.getReason(), sf.getFaultCode(), sf.getSubCode()});
        return msg.toString();
    }
}

