/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.DataInput;
import java.io.IOException;
import org.jboss.as.controller.remote.ManagementOperationHandlerFactory;
import org.jboss.as.host.controller.ManagedServerLifecycleCallback;
import org.jboss.as.protocol.mgmt.ManagementOperationHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.old.ProtocolUtils;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ServerToHostOperationHandlerFactoryService
implements ManagementOperationHandlerFactory,
Service<ManagementOperationHandlerFactory> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.host.controller.mgmt");
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"management", "server", "to", "host", "controller"});
    private final InjectedValue<ManagedServerLifecycleCallback> callback = new InjectedValue();

    private ServerToHostOperationHandlerFactoryService() {
    }

    public static void install(ServiceTarget serviceTarget, ServiceName serverInventoryName) {
        ServerToHostOperationHandlerFactoryService serverToHost = new ServerToHostOperationHandlerFactoryService();
        serviceTarget.addService(SERVICE_NAME, (Service)serverToHost).addDependency(serverInventoryName, ManagedServerLifecycleCallback.class, serverToHost.callback).install();
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public ManagementOperationHandlerFactory getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ManagementOperationHandler createOperationHandler() {
        return new ServerToHostOperationHandler();
    }

    private class ServerToHostOperationHandler
    implements ManagementOperationHandler {
        private volatile ManagementOperationHandler proxyOperationHandler;

        private ServerToHostOperationHandler() {
        }

        public ManagementRequestHandler getRequestHandler(byte id) {
            ManagementRequestHandler handler;
            if (id == 0) {
                return new ServerRegisterCommand();
            }
            if (this.proxyOperationHandler != null && (handler = this.proxyOperationHandler.getRequestHandler(id)) != null) {
                return handler;
            }
            return null;
        }

        private class ServerRegisterCommand
        extends ManagementRequestHandler {
            String serverName;

            private ServerRegisterCommand() {
            }

            protected void readRequest(DataInput input) throws IOException {
                ProtocolUtils.expectHeader((DataInput)input, (int)1);
                this.serverName = input.readUTF();
                log.infof("Server [%s] registered using connection [%s]", (Object)this.serverName, (Object)this.getChannel());
            }

            protected void processRequest() {
                ((ManagedServerLifecycleCallback)ServerToHostOperationHandlerFactoryService.this.callback.getValue()).serverRegistered(this.serverName, this.getChannel(), new ManagedServerLifecycleCallback.ProxyCreatedCallback(){

                    @Override
                    public void proxyOperationHandlerCreated(ManagementOperationHandler handler) {
                        ServerToHostOperationHandler.this.proxyOperationHandler = handler;
                    }
                });
            }
        }
    }
}

