#!/bin/sh

HAMACHI_DST=/opt/logmein-hamachi

if [ ! -x /usr/lib/lsb/install_initd ] ; then
	echo LogMeIn Hamachi2 needs lsb package;
	exit 1;
fi

if [ -x /opt/logmein-hamachi/uninstall.sh ] ; then
	echo Removing previous version ..
	/opt/logmein-hamachi/uninstall.sh
fi

echo Copying files into $HAMACHI_DST ..
mkdir -p "$HAMACHI_DST/bin"
install -m 755 hamachid "$HAMACHI_DST/bin"
install -m 755 dnsup "$HAMACHI_DST/bin"
install -m 755 dnsdown "$HAMACHI_DST/bin"
install -m 755 uninstall.sh "$HAMACHI_DST"
install -m 444 README "$HAMACHI_DST"
install -m 444 LICENSE "$HAMACHI_DST"
install -m 444 CHANGES "$HAMACHI_DST"

echo Creating LogMeIn Hamachi2 symlink ..
ln -sf "$HAMACHI_DST/bin/hamachid" /usr/bin/hamachi

echo Installing LogMeIn Hamachi2 service ..
install -m 755 hamachi-init /etc/init.d/logmein-hamachi
/usr/lib/lsb/install_initd /etc/init.d/logmein-hamachi

echo Starting LogMeIn Hamachi2 service ..
/etc/init.d/logmein-hamachi start

echo LogMeIn Hamachi2 is installed. See README for what to do next.
