/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.websockets;

import java.io.IOException;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.websockets.BaseWebSocketFilter;
import org.glassfish.grizzly.websockets.WebSocketHolder;

public class WebSocketClientFilter
extends BaseWebSocketFilter {
    @Override
    protected NextAction handleHandshake(FilterChainContext ctx, HttpContent content) throws IOException {
        return WebSocketClientFilter.handleClientHandShake(ctx, content);
    }

    private static NextAction handleClientHandShake(FilterChainContext ctx, HttpContent content) {
        WebSocketHolder holder = WebSocketHolder.get(ctx.getConnection());
        holder.handshake.validateServerResponse((HttpResponsePacket)content.getHttpHeader());
        holder.webSocket.onConnect();
        if (content.getContent().hasRemaining()) {
            return ctx.getRerunFilterAction();
        }
        content.recycle();
        return ctx.getStopAction();
    }
}

