/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.ha.session.management;

import com.sun.enterprise.container.common.spi.util.JavaEEIOUtils;
import com.sun.web.security.RealmAdapter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.web.ha.session.management.BaseHASession;
import org.glassfish.web.ha.session.management.CompositeMetadata;
import org.glassfish.web.ha.session.management.HASession;
import org.glassfish.web.ha.session.management.ModifiedAttributeHASession;
import org.glassfish.web.ha.session.management.ReplicationManagerBase;
import org.glassfish.web.ha.session.management.ReplicationStore;
import org.glassfish.web.ha.session.management.SessionAttributeMetadata;

public class ReplicationAttributeStore
extends ReplicationStore {
    public ReplicationAttributeStore(JavaEEIOUtils ioUtils) {
        super(ioUtils);
        this.setLogLevel();
    }

    @Override
    public void valveSave(Session session) throws IOException {
        if (!(session instanceof HASession)) {
            return;
        }
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doValveSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    @Override
    public void save(Session session) throws IOException {
        if (!(session instanceof HASession)) {
            return;
        }
        HASession haSess = (HASession)session;
        if (haSess.isPersistent() && !haSess.isDirty()) {
            this.updateLastAccessTime(session);
        } else {
            this.doSave(session);
            haSess.setPersistent(true);
        }
        haSess.setDirty(false);
    }

    @Override
    public void doValveSave(Session session) throws IOException {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>doValveSave:valid =" + ((StandardSession)session).getIsValid());
            if (session instanceof HASession) {
                _logger.fine("ReplicationAttributeStore>>valveSave:ssoId=" + ((HASession)session).getSsoId());
            }
        }
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        if (!(session instanceof ModifiedAttributeHASession) || !(session instanceof BaseHASession)) {
            return;
        }
        ModifiedAttributeHASession modAttrSession = (ModifiedAttributeHASession)session;
        String userName = "";
        if (session.getPrincipal() != null) {
            userName = session.getPrincipal().getName();
            ((BaseHASession)session).setUserName(userName);
        }
        BackingStore<String, CompositeMetadata> replicator = this.getCompositeMetadataBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>save: replicator: " + replicator);
        }
        CompositeMetadata compositeMetadata = this.createCompositeMetadata(modAttrSession);
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("CompositeMetadata is " + compositeMetadata + " id is " + session.getIdInternal());
            }
            replicator.save((Serializable)((Object)session.getIdInternal()), (Serializable)((Object)compositeMetadata), !((HASession)session).isPersistent());
            modAttrSession.resetAttributeState();
            this.postSaveUpdate(modAttrSession);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    @Override
    public void doSave(Session session) throws IOException {
        if (!((StandardSession)session).getIsValid()) {
            return;
        }
        if (!(session instanceof ModifiedAttributeHASession) || !(session instanceof HASession)) {
            return;
        }
        ModifiedAttributeHASession modAttrSession = (ModifiedAttributeHASession)session;
        BackingStore<String, CompositeMetadata> replicator = this.getCompositeMetadataBackingStore();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>doSave: replicator: " + replicator);
        }
        CompositeMetadata compositeMetadata = this.createCompositeMetadata(modAttrSession);
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("CompositeMetadata is " + compositeMetadata + " id is " + session.getIdInternal());
            }
            replicator.save((Serializable)((Object)session.getIdInternal()), (Serializable)((Object)compositeMetadata), !((HASession)session).isPersistent());
            modAttrSession.resetAttributeState();
            this.postSaveUpdate(modAttrSession);
        }
        catch (BackingStoreException ex) {
            // empty catch block
        }
    }

    private BackingStore<String, CompositeMetadata> getCompositeMetadataBackingStore() {
        ReplicationManagerBase mgr = (ReplicationManagerBase)this.getManager();
        return mgr.getBackingStore();
    }

    @Override
    public Session load(String id, String version) throws ClassNotFoundException, IOException {
        try {
            CompositeMetadata metaData = (CompositeMetadata)((Object)this.getCompositeMetadataBackingStore().load((Serializable)((Object)id), version));
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationAttributeStore>>load:id=" + id + ", metaData=" + metaData);
            }
            Session session = this.getSession(metaData);
            this.validateAndSave(session);
            return session;
        }
        catch (BackingStoreException ex) {
            IOException ex1 = (IOException)new IOException("Error during load: " + ex.getMessage()).initCause(ex);
            throw ex1;
        }
    }

    private void validateAndSave(Session session) throws IOException {
        if (session != null) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("ReplicationAttributeStore>>validateAndSave saving the session after loading it. Session=" + session);
            }
            ((HASession)session).setDirty(true);
            this.valveSave(session);
        }
        if (session != null) {
            ((HASession)session).setDirty(false);
            ((HASession)session).setPersistent(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(CompositeMetadata metadata) throws IOException {
        long version;
        String ssoId;
        Principal pal;
        Container container;
        Session _session;
        block25: {
            if (metadata == null || metadata.getState() == null) {
                return null;
            }
            byte[] state = metadata.getState();
            _session = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            container = this.manager.getContainer();
            pal = null;
            ssoId = null;
            version = 0L;
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                ssoId = metadata.getStringExtraParam();
                version = metadata.getVersion();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("loaded session from replicationstore, length = " + state.length);
                }
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    try {
                        ois = this.ioUtils.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block25;
                try {
                    _session = this.readSession(this.manager, ois);
                }
                finally {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e) {}
                }
            }
            catch (ClassNotFoundException e) {
                IOException ex1 = (IOException)new IOException("Error during deserialization: " + e.getMessage()).initCause(e);
                throw ex1;
            }
            catch (IOException e) {
                throw e;
            }
        }
        String username = ((HASession)_session).getUserName();
        if (username != null && !username.equals("") && _session.getPrincipal() == null) {
            if (this._debug > 0) {
                this.debug("Username retrieved is " + username);
            }
            pal = ((RealmAdapter)container.getRealm()).createFailOveredPrincipal(username);
            if (this._debug > 0) {
                this.debug("principal created using username  " + pal);
            }
            if (pal != null) {
                _session.setPrincipal(pal);
                if (this._debug > 0) {
                    this.debug("getSession principal=" + pal + " was added to session=" + _session);
                }
            }
        }
        _session.setNew(false);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>ssoId=" + ssoId);
        }
        ((HASession)_session).setVersion(version);
        ((HASession)_session).setDirty(false);
        ((ModifiedAttributeHASession)_session).clearAttributeStates();
        byte[] entriesState = metadata.getState();
        Collection entries = null;
        if (entriesState != null) {
            entries = this.deserializeStatesCollection(entriesState);
            this.loadAttributes((ModifiedAttributeHASession)_session, entries);
        }
        this.loadAttributes((ModifiedAttributeHASession)_session, metadata.getEntries());
        return _session;
    }

    private void postSaveUpdate(ModifiedAttributeHASession modAttrSession) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>postSaveUpdate");
        }
        List<String> addedAttrs = modAttrSession.getAddedAttributes();
        List<String> modifiedAttrs = modAttrSession.getModifiedAttributes();
        List<String> deletedAttrs = modAttrSession.getDeletedAttributes();
        this.printAttrList("ADDED", addedAttrs);
        this.printAttrList("MODIFIED", modifiedAttrs);
        this.printAttrList("DELETED", deletedAttrs);
        this.postProcessSetAttrStates(modAttrSession, addedAttrs);
        this.postProcessSetAttrStates(modAttrSession, modifiedAttrs);
    }

    private void postProcessSetAttrStates(ModifiedAttributeHASession modAttrSession, List<String> attrsList) {
        for (int i = 0; i < attrsList.size(); ++i) {
            String nextStateName = attrsList.get(i);
            modAttrSession.setAttributeStatePersistent(nextStateName, true);
            modAttrSession.setAttributeStateDirty(nextStateName, false);
        }
    }

    private CompositeMetadata createCompositeMetadata(ModifiedAttributeHASession modAttrSession) {
        byte[] trunkState = null;
        if (modAttrSession.isNew()) {
            try {
                trunkState = this.getByteArray(modAttrSession);
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("ReplicationAttributeStore>>createCompositeMetadata:trunkState=" + trunkState);
        }
        ArrayList<SessionAttributeMetadata> entries = new ArrayList<SessionAttributeMetadata>();
        List<String> addedAttrs = modAttrSession.getAddedAttributes();
        List<String> modifiedAttrs = modAttrSession.getModifiedAttributes();
        List<String> deletedAttrs = modAttrSession.getDeletedAttributes();
        this.printAttrList("ADDED", addedAttrs);
        this.printAttrList("MODIFIED", modifiedAttrs);
        this.printAttrList("DELETED", deletedAttrs);
        this.addToEntries(modAttrSession, entries, SessionAttributeMetadata.Operation.ADD, addedAttrs);
        this.addToEntries(modAttrSession, entries, SessionAttributeMetadata.Operation.UPDATE, modifiedAttrs);
        this.addToEntries(modAttrSession, entries, SessionAttributeMetadata.Operation.DELETE, deletedAttrs);
        CompositeMetadata result = new CompositeMetadata(modAttrSession.getVersion(), modAttrSession.getLastAccessedTimeInternal(), (long)modAttrSession.getMaxInactiveInterval() * 1000L, entries, trunkState, null);
        return result;
    }

    private void printAttrList(String attrListType, List<String> attrList) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("AttributeType = " + attrListType);
            String nextAttrName = null;
            for (int i = 0; i < attrList.size(); ++i) {
                nextAttrName = attrList.get(i);
                _logger.fine("attribute[" + i + "]=" + nextAttrName);
            }
        }
    }

    private void addToEntries(ModifiedAttributeHASession modAttrSession, List<SessionAttributeMetadata> entries, SessionAttributeMetadata.Operation op, List<String> attrList) {
        String nextAttrName = null;
        Object nextAttrValue = null;
        byte[] nextValue = null;
        for (int i = 0; i < attrList.size(); ++i) {
            nextAttrName = attrList.get(i);
            nextAttrValue = modAttrSession.getAttribute(nextAttrName);
            nextValue = null;
            try {
                nextValue = this.getByteArray(nextAttrValue);
            }
            catch (IOException ex) {
                // empty catch block
            }
            SessionAttributeMetadata nextAttrMetadata = new SessionAttributeMetadata(nextAttrName, op, nextValue);
            entries.add(nextAttrMetadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArray(Object attributeValue) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        try (ObjectOutputStream oos = null;){
            bos = new ByteArrayOutputStream();
            try {
                oos = this.ioUtils.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            oos.writeObject(attributeValue);
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttributeValue(byte[] state) throws IOException, ClassNotFoundException {
        Object attributeValue;
        block17: {
            attributeValue = null;
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    try {
                        ois = this.ioUtils.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block17;
                try {
                    attributeValue = ois.readObject();
                }
                finally {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e) {}
                }
            }
            catch (ClassNotFoundException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "ClassNotFoundException occurred in getAttributeValue", e);
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return attributeValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getByteArrayFromCollection(Collection entries) throws IOException {
        byte[] obs;
        ByteArrayOutputStream bos = null;
        try (ObjectOutputStream oos = null;){
            bos = new ByteArrayOutputStream();
            try {
                oos = this.ioUtils.createObjectOutputStream((OutputStream)new BufferedOutputStream(bos), true);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (oos == null) {
                oos = new ObjectOutputStream(new BufferedOutputStream(bos));
            }
            int entriesSize = entries.size();
            oos.writeObject(entriesSize);
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                oos.writeObject(it.next());
            }
            oos.close();
            oos = null;
            obs = bos.toByteArray();
        }
        return obs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAttributeValueCollection(byte[] state) throws IOException, ClassNotFoundException {
        ArrayList<Object> attributeValueList;
        block19: {
            attributeValueList = new ArrayList<Object>();
            BufferedInputStream bis = null;
            ByteArrayInputStream bais = null;
            Loader loader = null;
            ClassLoader classLoader = null;
            ObjectInputStream ois = null;
            Container container = this.manager.getContainer();
            try {
                bais = new ByteArrayInputStream(state);
                bis = new BufferedInputStream(bais);
                if (container != null) {
                    loader = container.getLoader();
                }
                if (loader != null) {
                    classLoader = loader.getClassLoader();
                }
                if (classLoader != null) {
                    try {
                        ois = this.ioUtils.createObjectInputStream((InputStream)bis, true, classLoader);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (ois == null) {
                    ois = new ObjectInputStream(bis);
                }
                if (ois == null) break block19;
                try {
                    Object whatIsIt = ois.readObject();
                    int entriesSize = 0;
                    if (whatIsIt instanceof Integer) {
                        entriesSize = (Integer)whatIsIt;
                    }
                    for (int i = 0; i < entriesSize; ++i) {
                        Object nextAttributeValue = ois.readObject();
                        attributeValueList.add(nextAttributeValue);
                    }
                }
                finally {
                    try {
                        ois.close();
                        bis = null;
                    }
                    catch (IOException e) {}
                }
            }
            catch (ClassNotFoundException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "ClassNotFoundException occurred in getAttributeValueCollection", e);
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        return attributeValueList;
    }

    protected void loadAttributes(ModifiedAttributeHASession modifiedAttributeSession, Collection attributeList) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in loadAttributes -- ReplicationAttributeStore : session id=" + modifiedAttributeSession.getIdInternal());
        }
        String thisAttrName = null;
        Object thisAttrVal = null;
        for (SessionAttributeMetadata nextAttrMetadata : attributeList) {
            thisAttrName = nextAttrMetadata.getAttributeName();
            byte[] nextAttrState = nextAttrMetadata.getState();
            thisAttrVal = null;
            try {
                thisAttrVal = this.getAttributeValue(nextAttrState);
            }
            catch (ClassNotFoundException ex1) {
            }
            catch (IOException ex2) {
                // empty catch block
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Attr retrieved======" + thisAttrName);
            }
            if (thisAttrVal == null) continue;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Setting Attribute: " + thisAttrName);
            }
            modifiedAttributeSession.setAttribute(thisAttrName, thisAttrVal);
            modifiedAttributeSession.setAttributeStatePersistent(thisAttrName, false);
            modifiedAttributeSession.setAttributeStateDirty(thisAttrName, false);
        }
    }

    private Collection deserializeStatesCollection(byte[] entriesState) {
        Collection result = new ArrayList();
        try {
            result = (Collection)this.getAttributeValueCollection(entriesState);
        }
        catch (ClassNotFoundException ex1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }
}

