/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.glassfish.weld.RootBeanDeploymentArchive;
import org.jboss.weld.Container;
import org.jboss.weld.SimpleCDI;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.manager.BeanManagerImpl;

public class GlassFishWeldProvider
implements CDIProvider {
    public CDI<Object> getCDI() {
        try {
            return new GlassFishEnhancedWeld();
        }
        catch (Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause instanceof IllegalStateException) {
                return null;
            }
            throw throwable;
        }
    }

    private static class GlassFishEnhancedWeld
    extends SimpleCDI {
        private GlassFishEnhancedWeld() {
        }

        protected BeanManagerImpl unsatisfiedBeanManager(String callerClassName) {
            if (Container.instance().beanDeploymentArchives().values().size() == 1) {
                return (BeanManagerImpl)Container.instance().beanDeploymentArchives().values().iterator().next();
            }
            Map beanDeploymentArchives = Container.instance().beanDeploymentArchives();
            Set entries = beanDeploymentArchives.entrySet();
            for (Map.Entry entry : entries) {
                BeanDeploymentArchive beanDeploymentArchive = (BeanDeploymentArchive)entry.getKey();
                if (!(beanDeploymentArchive instanceof RootBeanDeploymentArchive)) continue;
                RootBeanDeploymentArchive rootBeanDeploymentArchive = (RootBeanDeploymentArchive)beanDeploymentArchive;
                ClassLoader moduleClassLoaderForBDA = rootBeanDeploymentArchive.getModuleClassLoaderForBDA();
                try {
                    Class.forName(callerClassName, false, moduleClassLoaderForBDA);
                    return (BeanManagerImpl)entry.getValue();
                }
                catch (Exception ignore) {
                }
            }
            return super.unsatisfiedBeanManager(callerClassName);
        }
    }
}

