/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.config.support.Strings;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class SystemPropertyUpgrade
implements ConfigurationUpgrade,
PostConstruct {
    @Inject
    Configs configs;
    @Inject
    Domain domain;
    @Inject
    Servers servers;
    @Inject
    @Named(value="gmsupgrade")
    @Optional
    ConfigurationUpgrade precondition = null;
    private String PREFIX = "2";
    private int DEFAULT_ADMIN_PORT = 4848;
    private static final String DAS_CONFIG = "server-config";
    private static final String DEFAULT_CONFIG = "default-config";
    private static final String DAS = "server";

    @Override
    public void postConstruct() {
        this.upgradeConfigElements();
        this.upgradeServerElements();
    }

    private void upgradeConfigElements() {
        int incr = 0;
        for (Config c : this.configs.getConfig()) {
            try {
                int debugPort;
                int osgiPort;
                int adminPort;
                Config bag;
                String httpVal;
                if (c.getName().equals(DAS_CONFIG) || (httpVal = (bag = c).getSystemProperty("HTTP_LISTENER_PORT").getValue()) == null) continue;
                this.PREFIX = httpVal.substring(0, httpVal.length() - 4);
                if (!c.getName().equals(DEFAULT_CONFIG)) {
                    adminPort = this.DEFAULT_ADMIN_PORT + incr;
                    osgiPort = 6666 + incr;
                    debugPort = 9009 + incr;
                    ++incr;
                } else {
                    adminPort = this.DEFAULT_ADMIN_PORT;
                    osgiPort = 6666;
                    debugPort = 9009;
                }
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SystemPropertyBag>(){

                    public Object run(SystemPropertyBag config) throws PropertyVetoException, TransactionFailure {
                        SystemPropertyUpgrade.this.createSystemProperty(config, "ASADMIN_LISTENER_PORT", adminPort);
                        SystemPropertyUpgrade.this.createSystemProperty(config, "OSGI_SHELL_TELNET_PORT", osgiPort);
                        SystemPropertyUpgrade.this.createSystemProperty(config, "JAVA_DEBUGGER_PORT", debugPort);
                        return null;
                    }
                }, (ConfigBeanProxy)c);
            }
            catch (Exception e) {
                Logger.getAnonymousLogger().log(Level.SEVERE, Strings.get("SystemPropertyUpgrade.Failure", c), e);
                throw new RuntimeException(e);
            }
        }
    }

    private void upgradeServerElements() {
        int incr = 0;
        for (Cluster c : this.domain.getClusters().getCluster()) {
            for (Server s : c.getInstances()) {
                incr = this.createServerSystemProperty(s, incr);
            }
        }
    }

    private int createServerSystemProperty(Server s, int incr) {
        try {
            String httpVal;
            Server bag;
            if (!s.getName().equals(DAS) && (bag = s).getSystemProperty("HTTP_LISTENER_PORT") != null && (httpVal = bag.getSystemProperty("HTTP_LISTENER_PORT").getValue()) != null) {
                this.PREFIX = httpVal.substring(0, httpVal.length() - 5);
                String configAdminSP = null;
                String configOsgiSP = null;
                String configDebugSP = null;
                for (SystemProperty sp : s.getConfig().getSystemProperty()) {
                    if (sp.getName().equals("ASADMIN_LISTENER_PORT")) {
                        configAdminSP = sp.getValue();
                    }
                    if (sp.getName().equals("OSGI_SHELL_TELNET_PORT")) {
                        configOsgiSP = sp.getValue();
                    }
                    if (!sp.getName().equals("JAVA_DEBUGGER_PORT")) continue;
                    configDebugSP = sp.getValue();
                }
                int baseAdmin = configAdminSP == null ? this.DEFAULT_ADMIN_PORT : Integer.parseInt(configAdminSP);
                int baseOsgi = configOsgiSP == null ? 6666 : Integer.parseInt(configOsgiSP);
                int baseDebug = configDebugSP == null ? 9009 : Integer.parseInt(configDebugSP);
                final int adminPort = baseAdmin + ++incr;
                final int osgiPort = baseOsgi + incr;
                final int debugPort = baseDebug + incr;
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<SystemPropertyBag>(){

                    public Object run(SystemPropertyBag config) throws PropertyVetoException, TransactionFailure {
                        SystemPropertyUpgrade.this.createSystemProperty(config, "ASADMIN_LISTENER_PORT", adminPort);
                        SystemPropertyUpgrade.this.createSystemProperty(config, "OSGI_SHELL_TELNET_PORT", osgiPort);
                        SystemPropertyUpgrade.this.createSystemProperty(config, "JAVA_DEBUGGER_PORT", debugPort);
                        return null;
                    }
                }, (ConfigBeanProxy)s);
            }
            return incr;
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, Strings.get("SystemPropertyUpgrade.Failure", s), e);
            throw new RuntimeException(e);
        }
    }

    private void createSystemProperty(SystemPropertyBag spb, String portName, int portVal) throws TransactionFailure, PropertyVetoException {
        if (spb.getSystemProperty(portName) == null) {
            SystemProperty newSysProp = (SystemProperty)spb.createChild(SystemProperty.class);
            newSysProp.setName(portName);
            newSysProp.setValue(this.PREFIX + portVal);
            spb.getSystemProperty().add(newSysProp);
        }
    }
}

