/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.Set;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.deployment.admin.DeployCommand;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.versioning.VersioningSyntaxException;
import org.glassfish.deployment.versioning.VersioningUtils;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-client-stubs")
@I18n(value="get.client.stubs")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.GET, path="get-client-stubs", description="Get Client Stubs", params={@RestParam(name="appname", value="$parent")})})
public class GetClientStubsCommand
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final String APPNAME = "appname";
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(GetClientStubsCommand.class);
    @Inject
    private Applications apps;
    @Param(name="appname", optional=false)
    private String appname = null;
    @Param(primary=true)
    private String localDir;
    @AccessRequired.To(value={"read"})
    private Application matchingApp = null;

    public boolean preAuthorization(AdminCommandContext context) {
        for (Application app : this.apps.getApplications()) {
            if (!app.getName().equals(this.appname)) continue;
            this.matchingApp = app;
            return true;
        }
        context.getActionReport().setMessage(localStrings.getLocalString(this.getClass(), "get-client-stubs.noSuchApp", "Application {0} was not found", new Object[]{this.appname}));
        return false;
    }

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        Set artifactInfo = DeploymentUtils.downloadableArtifacts((Application)this.matchingApp).getArtifacts();
        try {
            VersioningUtils.checkIdentifier((String)this.appname);
        }
        catch (VersioningSyntaxException ex) {
            report.failure(logger, ex.getMessage());
            return;
        }
        if (artifactInfo.size() == 0) {
            report.setMessage(localStrings.getLocalString(this.getClass(), "get-client-stubs.noStubApp", "there are no files to retrieve for application {0}", new Object[]{this.appname}));
            return;
        }
        try {
            DeployCommand.retrieveArtifacts(context, this.matchingApp, this.localDir);
        }
        catch (Exception e) {
            report.setFailureCause((Throwable)e);
            report.failure(logger, localStrings.getLocalString(this.getClass(), "get-client-stubs.errorPrepDownloadedFiles", "Error preparing for download"), (Throwable)e);
        }
    }
}

