/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.api;

import com.sun.enterprise.config.serverbeans.Resource;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ResourceProxy
implements NamingObjectProxy.InitializationNamingObjectProxy {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private ResourceNamingService namingService;
    private Resource resource = null;
    private Object result = null;
    private ResourceInfo resourceInfo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Context ic) throws NamingException {
        ResourceProxy resourceProxy = this;
        synchronized (resourceProxy) {
            try {
                if (this.result == null) {
                    this.getResourceDeployer(this.resource).deployResource(this.resource, this.resourceInfo.getApplicationName(), this.resourceInfo.getModuleName());
                }
                this.result = this.namingService.lookup(this.resourceInfo, this.resourceInfo.getName(), ic.getEnvironment());
            }
            catch (Exception e) {
                this.throwResourceNotFoundException(e, this.resourceInfo);
            }
        }
        return this.result;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void setResourceInfo(ResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }

    protected Object throwResourceNotFoundException(Exception e, ResourceInfo resourceInfo) throws NamingException {
        NamingException ne = new NamingException("Unable to lookup resource : " + resourceInfo);
        ne.initCause(e);
        throw ne;
    }

    protected ResourceDeployer getResourceDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }
}

