/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.common;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.Context;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.security.services.common.SecurityScope;
import org.glassfish.security.services.common.StateManager;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityScopeContext
implements Context<SecurityScope> {
    private final HashMap<String, HashMap<ActiveDescriptor<?>, Object>> contexts = new HashMap();
    @Inject
    private StateManager manager;

    @Override
    public Class<? extends Annotation> getScope() {
        return SecurityScope.class;
    }

    @Override
    public <T> T findOrCreate(ActiveDescriptor<T> activeDescriptor, ServiceHandle<?> root) {
        HashMap<ActiveDescriptor<?>, Object> mappings = this.getCurrentContext();
        Object retVal = mappings.get(activeDescriptor);
        if (retVal == null) {
            retVal = activeDescriptor.create(root);
            mappings.put(activeDescriptor, retVal);
        }
        return (T)retVal;
    }

    @Override
    public boolean containsKey(ActiveDescriptor<?> descriptor) {
        HashMap<ActiveDescriptor<?>, Object> mappings = this.getCurrentContext();
        return mappings.containsKey(descriptor);
    }

    @Override
    public boolean isActive() {
        return this.manager.getCurrent() != null;
    }

    private HashMap<ActiveDescriptor<?>, Object> getCurrentContext() {
        if (this.manager.getCurrent() == null) {
            throw new IllegalStateException("Not In Active State");
        }
        HashMap<ActiveDescriptor<Object>, Object> retVal = this.contexts.get(this.manager.getCurrent());
        if (retVal == null) {
            retVal = new HashMap();
            this.contexts.put(this.manager.getCurrent(), retVal);
        }
        return retVal;
    }

    @Override
    public boolean supportsNullCreation() {
        return false;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void destroyOne(ActiveDescriptor<?> descriptor) {
    }
}

