/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.ManagedBeanManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionException;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.InjectionTarget;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.ManagedBean;
import javax.inject.Inject;
import javax.naming.NamingException;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
public class InjectionManagerImpl
implements InjectionManager,
PostConstruct {
    @Inject
    private Logger _logger;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(InjectionManagerImpl.class);
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InvocationManager invocationMgr;
    @Inject
    private GlassfishNamingManager glassfishNamingManager;
    @Inject
    private ServiceLocator habitat;
    @Inject
    private ProcessEnvironment processEnv;

    public void postConstruct() {
        if (this.processEnv.getProcessType().isServer()) {
            try {
                this.glassfishNamingManager.publishObject("com.sun.enterprise.container.common.spi.util.InjectionManager", (Object)this, true);
            }
            catch (NamingException ne) {
                throw new RuntimeException(ne);
            }
        }
    }

    @Override
    public void injectInstance(Object instance) throws InjectionException {
        this.injectInstance(instance, true);
    }

    @Override
    public void injectInstance(Object instance, boolean invokePostConstruct) throws InjectionException {
        JndiNameEnvironment componentEnv;
        ComponentInvocation inv = this.invocationMgr.getCurrentInvocation();
        if (inv != null) {
            componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
            if (componentEnv == null) {
                throw new InjectionException(localStrings.getLocalString("injection-manager.no-descriptor-registered-for-invocation", "No descriptor registered for current invocation: {0}", new Object[]{inv}));
            }
        } else {
            throw new InjectionException(localStrings.getLocalString("injection-manager.null-invocation-context", "Null invocation context"));
        }
        this.inject(instance.getClass(), instance, componentEnv, null, invokePostConstruct);
    }

    @Override
    public void injectInstance(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.inject(instance.getClass(), instance, componentEnv, null, true);
    }

    @Override
    public void injectInstance(Object instance, JndiNameEnvironment componentEnv, boolean invokePostConstruct) throws InjectionException {
        this.inject(instance.getClass(), instance, componentEnv, null, invokePostConstruct);
    }

    @Override
    public void injectInstance(Object instance, String componentId, boolean invokePostConstruct) throws InjectionException {
        JndiNameEnvironment componentEnv;
        ComponentInvocation inv = this.invocationMgr.getCurrentInvocation();
        if (inv != null) {
            componentEnv = this.compEnvManager.getJndiNameEnvironment(componentId);
            if (componentEnv == null) {
                throw new InjectionException(localStrings.getLocalString("injection-manager.no-descriptor-registered-for-component", "No descriptor registered for componentId: {0}", new Object[]{componentId}));
            }
        } else {
            throw new InjectionException(localStrings.getLocalString("injection-manager.null-invocation-context", "Null invocation context"));
        }
        this.inject(instance.getClass(), instance, componentEnv, componentId, invokePostConstruct);
    }

    @Override
    public void injectClass(Class clazz, String componentId, boolean invokePostConstruct) throws InjectionException {
        JndiNameEnvironment componentEnv;
        ComponentInvocation inv = this.invocationMgr.getCurrentInvocation();
        if (inv != null) {
            componentEnv = this.compEnvManager.getJndiNameEnvironment(componentId);
            if (componentEnv == null) {
                throw new InjectionException(localStrings.getLocalString("injection-manager.no-descriptor-registered-for-component", "No descriptor registered for componentId: {0}", new Object[]{componentId}));
            }
        } else {
            throw new InjectionException(localStrings.getLocalString("injection-manager.null-invocation-context", "Null invocation context"));
        }
        this.injectClass(clazz, componentEnv, invokePostConstruct);
    }

    @Override
    public void injectClass(Class clazz, JndiNameEnvironment componentEnv) throws InjectionException {
        this.injectClass(clazz, componentEnv, true);
    }

    @Override
    public void injectClass(Class clazz, JndiNameEnvironment componentEnv, boolean invokePostConstruct) throws InjectionException {
        this.inject(clazz, null, componentEnv, null, invokePostConstruct);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePreDestroy(instance.getClass(), instance, componentEnv);
    }

    @Override
    public void invokeInstancePostConstruct(Object instance, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePostConstruct(instance.getClass(), instance, componentEnv);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance) throws InjectionException {
        this.invokeInstancePreDestroy(instance, true);
    }

    @Override
    public void invokeInstancePreDestroy(Object instance, boolean validate) throws InjectionException {
        ComponentInvocation inv = this.invocationMgr.getCurrentInvocation();
        if (inv != null) {
            JndiNameEnvironment componentEnv = this.compEnvManager.getJndiNameEnvironment(inv.getComponentId());
            if (componentEnv != null) {
                this.invokePreDestroy(instance.getClass(), instance, componentEnv);
            } else if (validate || this._logger.isLoggable(Level.FINE)) {
                String msg1 = localStrings.getLocalString("injection-manager.no-descriptor-registered-for-invocation", "No descriptor registered for current invocation: {0}", new Object[]{inv});
                if (validate) {
                    throw new InjectionException(msg1);
                }
                this._logger.log(Level.FINE, msg1);
            }
        } else if (validate || this._logger.isLoggable(Level.FINE)) {
            String msg2 = localStrings.getLocalString("injection-manager.null-invocation-context", "Null invocation context");
            if (validate) {
                throw new InjectionException(msg2);
            }
            this._logger.log(Level.FINE, msg2);
        }
    }

    @Override
    public void invokeClassPreDestroy(Class clazz, JndiNameEnvironment componentEnv) throws InjectionException {
        this.invokePreDestroy(clazz, null, componentEnv);
    }

    @Override
    public <T> T createManagedObject(Class<T> clazz) throws InjectionException {
        T managedObject = null;
        try {
            ManagedBean managedBeanAnn = clazz.getAnnotation(ManagedBean.class);
            ManagedBeanManager managedBeanMgr = (ManagedBeanManager)this.habitat.getService(ManagedBeanManager.class, new Annotation[0]);
            if (managedBeanAnn != null) {
                managedObject = managedBeanMgr.createManagedBean(clazz);
            } else {
                JCDIService jcdiService = (JCDIService)this.habitat.getService(JCDIService.class, new Annotation[0]);
                if (jcdiService != null && jcdiService.isCurrentModuleJCDIEnabled()) {
                    managedObject = managedBeanMgr.createManagedBean(clazz);
                } else {
                    Constructor<T> noArgCtor = clazz.getConstructor(new Class[0]);
                    managedObject = noArgCtor.newInstance(new Object[0]);
                    this.injectInstance(managedObject);
                }
            }
        }
        catch (Exception e) {
            throw new InjectionException(localStrings.getLocalString("injection-manager.error-creating-managed-object", "Error creating managed object for class: {0}", new Object[]{clazz}), e);
        }
        return managedObject;
    }

    @Override
    public <T> T createManagedObject(Class<T> clazz, boolean invokePostConstruct) throws InjectionException {
        T managedObject = null;
        try {
            ManagedBean managedBeanAnn = clazz.getAnnotation(ManagedBean.class);
            ManagedBeanManager managedBeanMgr = (ManagedBeanManager)this.habitat.getService(ManagedBeanManager.class, new Annotation[0]);
            if (managedBeanAnn != null) {
                managedObject = managedBeanMgr.createManagedBean(clazz, invokePostConstruct);
            } else {
                JCDIService jcdiService = (JCDIService)this.habitat.getService(JCDIService.class, new Annotation[0]);
                if (jcdiService != null && jcdiService.isCurrentModuleJCDIEnabled()) {
                    managedObject = managedBeanMgr.createManagedBean(clazz, invokePostConstruct);
                } else {
                    Constructor<T> noArgCtor = clazz.getConstructor(new Class[0]);
                    managedObject = noArgCtor.newInstance(new Object[0]);
                    this.injectInstance(managedObject, invokePostConstruct);
                }
            }
        }
        catch (Exception e) {
            throw new InjectionException(localStrings.getLocalString("injection-manager.error-creating-managed-object", "Error creating managed object for class: {0}", new Object[]{clazz}), e);
        }
        return managedObject;
    }

    @Override
    public void destroyManagedObject(Object managedObject) throws InjectionException {
        this.destroyManagedObject(managedObject, true);
    }

    @Override
    public void destroyManagedObject(Object managedObject, boolean validate) throws InjectionException {
        Class<?> managedObjectClass = managedObject.getClass();
        ManagedBean managedBeanAnn = managedObjectClass.getAnnotation(ManagedBean.class);
        ManagedBeanManager managedBeanMgr = (ManagedBeanManager)this.habitat.getService(ManagedBeanManager.class, new Annotation[0]);
        JCDIService jcdiService = (JCDIService)this.habitat.getService(JCDIService.class, new Annotation[0]);
        if (jcdiService != null && jcdiService.isCurrentModuleJCDIEnabled()) {
            managedBeanMgr.destroyManagedBean(managedObject, validate);
        } else {
            boolean isManagedBean;
            boolean bl = isManagedBean = managedBeanAnn != null || managedBeanMgr.isManagedBean(managedObject);
            if (isManagedBean) {
                managedBeanMgr.destroyManagedBean(managedObject, validate);
            } else {
                this.invokeInstancePreDestroy(managedObject, validate);
            }
        }
    }

    @Override
    public void inject(Class clazz, Object instance, JndiNameEnvironment envDescriptor, String componentId, boolean invokePostConstruct) throws InjectionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (injInfo.getInjectionResources().size() > 0) {
                this._inject(nextClass, instance, componentId, injInfo.getInjectionResources());
            }
            if (!invokePostConstruct || injInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private void invokePreDestroy(Class clazz, Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LinkedList<Method> preDestroyMethods = new LinkedList<Method>();
        for (Class nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (injInfo.getPreDestroyMethodName() == null) continue;
            Method preDestroyMethod = this.getPreDestroyMethod(injInfo, nextClass);
            preDestroyMethods.addFirst(preDestroyMethod);
        }
        for (Method preDestroyMethod : preDestroyMethods) {
            this.invokeLifecycleMethod(preDestroyMethod, instance);
        }
    }

    private void invokePostConstruct(Class clazz, Object instance, JndiNameEnvironment envDescriptor) throws InjectionException {
        LinkedList<Method> postConstructMethods = new LinkedList<Method>();
        for (Class nextClass = clazz; nextClass != Object.class && nextClass != null; nextClass = nextClass.getSuperclass()) {
            InjectionInfo injInfo = envDescriptor.getInjectionInfoByClass(nextClass);
            if (injInfo.getPostConstructMethodName() == null) continue;
            Method postConstructMethod = this.getPostConstructMethod(injInfo, nextClass);
            postConstructMethods.addFirst(postConstructMethod);
        }
        for (Method postConstructMethod : postConstructMethods) {
            this.invokeLifecycleMethod(postConstructMethod, instance);
        }
    }

    private void _inject(Class clazz, final Object instance, String componentId, List<InjectionCapable> injectableResources) throws InjectionException {
        for (InjectionCapable next : injectableResources) {
            try {
                String lookupName = next.getComponentEnvName();
                if (!lookupName.startsWith("java:")) {
                    lookupName = "java:comp/env/" + lookupName;
                }
                final Object value = componentId != null ? this.glassfishNamingManager.lookup(componentId, lookupName) : this.glassfishNamingManager.getInitialContext().lookup(lookupName);
                for (InjectionTarget target : next.getInjectionTargets()) {
                    if (!clazz.getName().equals(target.getClassName())) continue;
                    if (target.isFieldInjectable()) {
                        final Field f = this.getField(target, clazz);
                        if (Modifier.isStatic(f.getModifiers()) && instance != null) {
                            throw new InjectionException(localStrings.getLocalString("injection-manager.illegal-use-of-static-field", "Illegal use of static field on class that only supports instance-based injection: {0}", new Object[]{f}));
                        }
                        if (instance == null && !Modifier.isStatic(f.getModifiers())) {
                            throw new InjectionException(localStrings.getLocalString("injection-manager.appclient-injected-field-must-be-static", "Injected field: {0} on Application Client class: {1} must be declared static", new Object[]{f, clazz}));
                        }
                        if (this._logger.isLoggable(Level.FINE)) {
                            this._logger.fine(localStrings.getLocalString("injection-manager.injecting-dependency-field", "Injecting dependency with logical name: {0} into field: {1} on class: {2}", new Object[]{next.getComponentEnvName(), f, clazz}));
                        }
                        if (System.getSecurityManager() != null) {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                                public Object run() throws Exception {
                                    f.set(instance, value);
                                    return null;
                                }
                            });
                            continue;
                        }
                        f.set(instance, value);
                        continue;
                    }
                    if (!target.isMethodInjectable()) continue;
                    final Method m = this.getMethod(next, target, clazz);
                    if (Modifier.isStatic(m.getModifiers()) && instance != null) {
                        throw new InjectionException(localStrings.getLocalString("injection-manager.illegal-use-of-static-method", "Illegal use of static method on class that only supports instance-based injection: {0}", new Object[]{m}));
                    }
                    if (instance == null && !Modifier.isStatic(m.getModifiers())) {
                        throw new InjectionException(localStrings.getLocalString("injection-manager.appclient-injected-method-must-be-static", "Injected method: {0} on Application Client class: {1} must be declared static", new Object[]{m, clazz}));
                    }
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.fine(localStrings.getLocalString("injection-manager.injecting-dependency-method", "Injecting dependency with logical name: {0} into method: {1} on class: {2}", new Object[]{next.getComponentEnvName(), m, clazz}));
                    }
                    if (System.getSecurityManager() != null) {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws Exception {
                                m.invoke(instance, value);
                                return null;
                            }
                        });
                        continue;
                    }
                    m.invoke(instance, value);
                }
            }
            catch (Throwable t) {
                Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
                String msg = localStrings.getLocalString("injection-manager.exception-to-inject", "Exception attempting to inject {0} into {1}: {2}", new Object[]{next, clazz, cause.getMessage()});
                this._logger.log(Level.FINE, msg, t);
                throw new InjectionException(msg, cause);
            }
        }
    }

    private void invokeLifecycleMethod(final Method lifecycleMethod, final Object instance) throws InjectionException {
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine(localStrings.getLocalString("injection-manager.calling-lifecycle-method", "Calling lifecycle method: {0} on class: {1}", new Object[]{lifecycleMethod, lifecycleMethod.getDeclaringClass()}));
            }
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    if (!lifecycleMethod.isAccessible()) {
                        lifecycleMethod.setAccessible(true);
                    }
                    lifecycleMethod.invoke(instance, new Object[0]);
                    return null;
                }
            });
        }
        catch (Throwable t) {
            String msg = localStrings.getLocalString("injection-manager.exception-invoke-lifecycle-method", "Exception attempting invoke lifecycle method: {0}", new Object[]{lifecycleMethod});
            this._logger.log(Level.FINE, msg, t);
            InjectionException ie = new InjectionException(msg);
            Throwable cause = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getCause() : t;
            ie.initCause(cause);
            throw ie;
        }
    }

    private Field getField(InjectionTarget target, Class resourceClass) throws Exception {
        Field f = target.getField();
        if (f == null) {
            try {
                final Field finalF = f = resourceClass.getDeclaredField(target.getFieldName());
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalF.isAccessible()) {
                            finalF.setAccessible(true);
                        }
                        return null;
                    }
                });
            }
            catch (NoSuchFieldException nsfe) {
                // empty catch block
            }
            if (f != null) {
                target.setField(f);
            }
        }
        if (f == null) {
            throw new Exception(localStrings.getLocalString("injection-manager.field-not-found", "InjectionManager exception.  Field: {0} not found in class: {1}", new Object[]{target.getFieldName(), resourceClass}));
        }
        return f;
    }

    private Method getMethod(InjectionCapable resource, InjectionTarget target, Class resourceClass) throws Exception {
        Method m = target.getMethod();
        if (m == null) {
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(target.getMethodName())) continue;
                m = next;
                target.setMethod(m);
                final Method finalM = m;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalM.isAccessible()) {
                            finalM.setAccessible(true);
                        }
                        return null;
                    }
                });
                break;
            }
        }
        if (m == null) {
            throw new Exception(localStrings.getLocalString("injection-manager.method-not-found", "InjectionManager exception.  Method: void {0} ({1}) not found in class: {2}", new Object[]{target.getMethodName(), resource.getInjectResourceType(), resourceClass}));
        }
        return m;
    }

    private Method getPostConstructMethod(InjectionInfo injInfo, Class resourceClass) throws InjectionException {
        Method m = injInfo.getPostConstructMethod();
        if (m == null) {
            String postConstructMethodName = injInfo.getPostConstructMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(postConstructMethodName) || next.getParameterTypes().length != 0) continue;
                m = next;
                injInfo.setPostConstructMethod(m);
                break;
            }
        }
        if (m == null) {
            throw new InjectionException(localStrings.getLocalString("injection-manager.postconstruct-not-found", "InjectionManager exception. PostConstruct method: {0} not found in class: {1}", new Object[]{injInfo.getPostConstructMethodName(), injInfo.getClassName()}));
        }
        return m;
    }

    private Method getPreDestroyMethod(InjectionInfo injInfo, Class resourceClass) throws InjectionException {
        Method m = injInfo.getPreDestroyMethod();
        if (m == null) {
            String preDestroyMethodName = injInfo.getPreDestroyMethodName();
            for (Method next : resourceClass.getDeclaredMethods()) {
                if (!next.getName().equals(preDestroyMethodName) || next.getParameterTypes().length != 0) continue;
                m = next;
                injInfo.setPreDestroyMethod(m);
                break;
            }
        }
        if (m == null) {
            throw new InjectionException(localStrings.getLocalString("injection-manager.predestroy-not-found", "InjectionManager exception. PreDestroy method: {0} not found in class: {1}", new Object[]{injInfo.getPreDestroyMethodName(), injInfo.getClassName()}));
        }
        return m;
    }
}

