/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.realm.BadRealmException;
import com.sun.enterprise.security.auth.realm.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.RealmConfig;
import com.sun.enterprise.security.auth.realm.RealmsProbeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class RealmsManager {
    private final Map<String, Hashtable<String, Realm>> loadedRealms = Collections.synchronizedMap(new HashMap());
    private volatile String defaultRealmName = "default";
    private final RealmsProbeProvider probeProvider = new RealmsProbeProvider();
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    @Inject
    @Named(value="default-instance-name")
    private Config config;
    private String defaultDigestAlgorithm = null;
    private static final String DEFAULT_DIGEST_ALGORITHM = "default-digest-algorithm";

    public boolean isValidRealm(String name) {
        if (name == null) {
            return false;
        }
        return this.configContainsRealm(name, this.config.getName());
    }

    public boolean isValidRealm(String configName, String name) {
        if (name == null) {
            return false;
        }
        return this.configContainsRealm(name, configName);
    }

    public Enumeration<String> getRealmNames() {
        return this.getRealmNames(this.config.getName());
    }

    Realm _getInstance(String configName, String name) {
        Realm retval = null;
        retval = this.configGetRealmInstance(configName, name);
        if (retval == null && "default".equals(name)) {
            retval = this.configGetRealmInstance(configName, this.getDefaultRealmName());
        }
        return retval;
    }

    Realm _getInstance(String name) {
        return this._getInstance(this.config.getName(), name);
    }

    public void removeFromLoadedRealms(String realmName) {
        Realm r = this.removeFromLoadedRealms(this.config.getName(), realmName);
        if (r != null) {
            this.probeProvider.realmRemovedEvent(realmName);
        }
    }

    void putIntoLoadedRealms(String realmName, Realm realm) {
        this.putIntoLoadedRealms(this.config.getName(), realmName, realm);
        this.probeProvider.realmAddedEvent(realmName);
    }

    public Realm getFromLoadedRealms(String realmName) {
        return this.configGetRealmInstance(this.config.getName(), realmName);
    }

    public Realm getFromLoadedRealms(String configName, String realmName) {
        return this.configGetRealmInstance(configName, realmName);
    }

    public synchronized String getDefaultRealmName() {
        return this.defaultRealmName;
    }

    public synchronized void setDefaultRealmName(String defaultRealmName) {
        this.defaultRealmName = defaultRealmName;
    }

    public List<String> getPredefinedAuthRealmClassNames() {
        ServiceLocator habitat = Globals.getDefaultHabitat();
        List<ActiveDescriptor<?>> collection = habitat.getDescriptors(BuilderHelper.createContractFilter(Realm.class.getName()));
        ArrayList<String> arr = new ArrayList<String>();
        for (ActiveDescriptor<?> it : collection) {
            arr.add(it.getImplementation());
        }
        return arr;
    }

    public void createRealms() {
        this.createRealms(this.config.getSecurityService(), this.config);
    }

    public void createRealms(Config cfg) {
        if (cfg == null) {
            return;
        }
        this.createRealms(cfg.getSecurityService(), cfg);
    }

    private void setDefaultDigestAlgorithm() {
        SecurityService service = this.config.getSecurityService();
        if (service == null) {
            return;
        }
        List props = service.getProperty();
        if (props == null) {
            return;
        }
        Iterator propsIterator = props.iterator();
        while (propsIterator != null && propsIterator.hasNext()) {
            Property prop = (Property)propsIterator.next();
            if (prop == null || !DEFAULT_DIGEST_ALGORITHM.equals(prop.getName())) continue;
            this.defaultDigestAlgorithm = prop.getValue();
            break;
        }
    }

    public String getDefaultDigestAlgorithm() {
        return this.defaultDigestAlgorithm;
    }

    private void createRealms(SecurityService securityBean, Config cfg) {
        if (this.realmsAlreadyLoaded(cfg.getName())) {
            return;
        }
        this.setDefaultDigestAlgorithm();
        try {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Initializing configured realms from SecurityService in Domain.xml....");
            }
            if (securityBean == null) {
                securityBean = cfg.getSecurityService();
                assert (securityBean != null);
            }
            String defaultRealm = securityBean.getDefaultRealm();
            List realms = securityBean.getAuthRealm();
            assert (realms != null);
            RealmConfig.createRealms(defaultRealm, realms, cfg.getName());
        }
        catch (Exception e) {
            _logger.log(Level.SEVERE, "NCLS-SECURITY-01101", e);
        }
    }

    private boolean realmsAlreadyLoaded(String cfgName) {
        Enumeration<String> en = this.getRealmNames(cfgName);
        return en != null && en.hasMoreElements();
    }

    private boolean configContainsRealm(String name, String configName) {
        Hashtable<String, Realm> containedRealms = this.loadedRealms.get(configName);
        return containedRealms != null ? containedRealms.containsKey(name) : false;
    }

    private Enumeration<String> getRealmNames(String configName) {
        Hashtable<String, Realm> containedRealms = this.loadedRealms.get(configName);
        return containedRealms != null ? containedRealms.keys() : null;
    }

    private Realm configGetRealmInstance(String configName, String realm) {
        Hashtable<String, Realm> containedRealms = this.loadedRealms.get(configName);
        return containedRealms != null ? containedRealms.get(realm) : null;
    }

    public Realm removeFromLoadedRealms(String configName, String realmName) {
        Hashtable<String, Realm> containedRealms = this.loadedRealms.get(configName);
        return containedRealms != null ? containedRealms.remove(realmName) : null;
    }

    public void putIntoLoadedRealms(String configName, String realmName, Realm realm) {
        Hashtable<String, Realm> containedRealms = this.loadedRealms.get(configName);
        if (containedRealms == null) {
            containedRealms = new Hashtable();
            if (configName == null) {
                configName = this.config.getName();
            }
            this.loadedRealms.put(configName, containedRealms);
        }
        containedRealms.put(realmName, realm);
    }

    public void refreshRealm(String configName, String realmName) {
        if (realmName != null && realmName.length() > 0) {
            try {
                Realm realm = Realm.getInstance(configName, realmName);
                if (realm != null) {
                    realm.refresh(configName);
                }
            }
            catch (NoSuchRealmException nre) {
            }
            catch (BadRealmException badRealmException) {
                // empty catch block
            }
        }
    }
}

