/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.concurrent;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftCache<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private static final int PROCESS_QUEUE_INTERVAL = 10;
    private int processQueueCount = 10;
    private Map<K, ValueCell<K, V>> hash;
    private ReferenceQueue<V> queue = new ReferenceQueue();
    private Set<Map.Entry<K, V>> entrySet = null;

    private void processQueue() {
        if (--this.processQueueCount == 0) {
            ValueCell vc;
            this.processQueueCount = 10;
            while ((vc = (ValueCell)this.queue.poll()) != null) {
                if (vc.isValid()) {
                    this.hash.remove(vc.key);
                    continue;
                }
                ValueCell.dropped--;
            }
        }
    }

    public SoftCache(int initialCapacity, float loadFactor) {
        this.hash = new HashMap<K, ValueCell<K, V>>(initialCapacity, loadFactor);
    }

    public SoftCache(int initialCapacity) {
        this.hash = new HashMap<K, ValueCell<K, V>>(initialCapacity);
    }

    public SoftCache() {
        this.hash = new HashMap<K, ValueCell<K, V>>();
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.entrySet().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return ValueCell.strip((ValueCell)this.hash.get(key), false) != null;
    }

    protected V fill(Object key) {
        return null;
    }

    @Override
    public V get(Object key) {
        V v;
        this.processQueue();
        ValueCell<K, V> vc = this.hash.get(key);
        if (vc == null && (v = this.fill(key)) != null) {
            this.hash.put(key, ValueCell.create(key, v, this.queue));
            return v;
        }
        return (V)ValueCell.strip((ValueCell)vc, false);
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        ValueCell vc = ValueCell.create(key, value, this.queue);
        return (V)ValueCell.strip(this.hash.put(key, vc), true);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        return (V)ValueCell.strip((ValueCell)this.hash.remove(key), true);
    }

    @Override
    public void clear() {
        this.processQueue();
        this.hash.clear();
    }

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private class Entry
    implements Map.Entry<K, V> {
        private Map.Entry<K, ValueCell<K, V>> ent;
        private V value;

        Entry(Map.Entry<K, ValueCell<K, V>> ent, V value) {
            this.ent = ent;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.ent.getKey();
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            this.ent.setValue(ValueCell.create(this.ent.getKey(), value, SoftCache.this.queue));
            return value;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return SoftCache.valEquals(this.ent.getKey(), e.getKey()) && SoftCache.valEquals(this.value, e.getValue());
        }

        @Override
        public int hashCode() {
            Object k = this.getKey();
            return (k == null ? 0 : k.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        Set<Map.Entry<K, ValueCell<K, V>>> hashEntries;

        private EntrySet() {
            this.hashEntries = SoftCache.this.hash.entrySet();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new Iterator<Map.Entry<K, V>>(){
                Iterator<Map.Entry<K, ValueCell<K, V>>> hashIterator;
                Entry next;
                {
                    this.hashIterator = EntrySet.this.hashEntries.iterator();
                    this.next = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.hashIterator.hasNext()) {
                        Map.Entry ent = this.hashIterator.next();
                        ValueCell vc = ent.getValue();
                        Object v = null;
                        if (vc != null) {
                            Object t = vc.get();
                            v = t;
                            if (t == null) continue;
                        }
                        this.next = new Entry(ent, v);
                        return true;
                    }
                    return false;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.hashIterator.remove();
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public int size() {
            int j = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                ++j;
                i.next();
            }
            return j;
        }

        public boolean remove(Map.Entry<K, V> o) {
            SoftCache.this.processQueue();
            if (Entry.class.isInstance(o)) {
                return this.hashEntries.remove(((Entry)o).ent);
            }
            return false;
        }
    }

    private static class ValueCell<K, V>
    extends SoftReference<V> {
        private static int dropped = 0;
        private boolean keyIsValid;
        private K key;

        private ValueCell(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.key = key;
            this.keyIsValid = true;
        }

        private static <K, V> ValueCell<K, V> create(K key, V value, ReferenceQueue<V> queue) {
            if (value == null) {
                return null;
            }
            return new ValueCell<K, V>(key, value, queue);
        }

        private static <K, V> V strip(ValueCell<K, V> val, boolean drop) {
            if (val == null) {
                return null;
            }
            Object o = val.get();
            if (drop) {
                super.drop();
            }
            return (V)o;
        }

        private boolean isValid() {
            return this.keyIsValid;
        }

        private void drop() {
            super.clear();
            this.keyIsValid = false;
            ++dropped;
        }
    }
}

