/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.EjbInvocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EJBTimerServiceWrapper;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.EjbFutureTask;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import java.rmi.Remote;
import javax.ejb.SessionContext;
import javax.ejb.TimerService;
import javax.transaction.UserTransaction;
import javax.xml.rpc.handler.MessageContext;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public abstract class AbstractSessionContextImpl
extends EJBContextImpl
implements SessionContext {
    protected Object instanceKey;
    protected String ejbName;

    protected AbstractSessionContextImpl(Object ejb, BaseContainer container) {
        super(ejb, container);
        EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)this.getContainer().getEjbDescriptor();
        this.ejbName = sessionDesc.getName();
    }

    public Object getInstanceKey() {
        return this.instanceKey;
    }

    public void setInstanceKey(Object instanceKey) {
        this.instanceKey = instanceKey;
    }

    public String toString() {
        return this.ejbName + "; id: " + this.instanceKey;
    }

    @Override
    public TimerService getTimerService() throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        EJBTimerService timerService = EJBTimerService.getValidEJBTimerService();
        return new EJBTimerServiceWrapper(timerService, this);
    }

    @Override
    public UserTransaction getUserTransaction() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED && this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        return ((BaseContainer)this.getContainer()).getUserTransaction();
    }

    @Override
    public MessageContext getMessageContext() {
        InvocationManager invManager = EjbContainerUtilImpl.getInstance().getInvocationManager();
        try {
            ComponentInvocation inv = invManager.getCurrentInvocation();
            if (inv != null && this.isWebServiceInvocation(inv)) {
                return ((EjbInvocation)inv).messageContext;
            }
            throw new IllegalStateException("Attempt to access MessageContext outside of a web service invocation");
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public <T> T getBusinessObject(Class<T> businessInterface) throws IllegalStateException {
        if (this.instanceKey == null) {
            throw new IllegalStateException("Operation not allowed");
        }
        Object businessObject = null;
        EjbDescriptor ejbDesc = this.container.getEjbDescriptor();
        if (businessInterface != null) {
            String intfName = businessInterface.getName();
            if (this.ejbLocalBusinessObjectImpl != null && ejbDesc.getLocalBusinessClassNames().contains(intfName)) {
                businessObject = this.ejbLocalBusinessObjectImpl.getClientObject(intfName);
            } else if (this.ejbRemoteBusinessObjectImpl != null && ejbDesc.getRemoteBusinessClassNames().contains(intfName)) {
                String generatedIntf = EJBUtils.getGeneratedRemoteIntfName(intfName);
                Remote stub = this.ejbRemoteBusinessObjectImpl.getStub(generatedIntf);
                try {
                    businessObject = EJBUtils.createRemoteBusinessObject(this.container.getClassLoader(), intfName, stub);
                }
                catch (Exception e) {
                    IllegalStateException ise = new IllegalStateException("Error creating remote business object for " + intfName);
                    ise.initCause(e);
                    throw ise;
                }
            } else if (ejbDesc.isLocalBean() && intfName.equals(ejbDesc.getEjbClassName())) {
                businessObject = this.optionalEjbLocalBusinessObjectImpl.getClientObject(ejbDesc.getEjbClassName());
            }
        }
        if (businessObject == null) {
            throw new IllegalStateException("Invalid business interface : " + businessInterface + " for ejb " + ejbDesc.getName());
        }
        return (T)businessObject;
    }

    @Override
    public Class getInvokedBusinessInterface() throws IllegalStateException {
        Class businessInterface = null;
        try {
            ComponentInvocation inv = EjbContainerUtilImpl.getInstance().getCurrentInvocation();
            if (inv != null && inv instanceof EjbInvocation) {
                EjbInvocation invocation = (EjbInvocation)inv;
                if (invocation.isBusinessInterface) {
                    businessInterface = invocation.clientInterface;
                    if (this.container.isLocalBeanClass(invocation.clientInterface.getName())) {
                        businessInterface = this.container.getEJBClass();
                    }
                }
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        if (businessInterface == null) {
            throw new IllegalStateException("Attempt to call getInvokedBusinessInterface outside the scope of a business method");
        }
        return businessInterface;
    }

    @Override
    public boolean wasCancelCalled() {
        try {
            ComponentInvocation inv = EjbContainerUtilImpl.getInstance().getCurrentInvocation();
            if (inv != null && inv instanceof EjbInvocation) {
                EjbInvocation invocation = (EjbInvocation)inv;
                EjbFutureTask task = invocation.getEjbFutureTask();
                if (task == null) {
                    throw new IllegalStateException("Must be invoked from an async method");
                }
                if (invocation.method.getReturnType() == Void.TYPE) {
                    throw new IllegalStateException("Must be invoked from a method with a Future<V> return type");
                }
                return invocation.getWasCancelCalled();
            }
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException(e.getMessage());
            ise.initCause(e);
            throw ise;
        }
        throw new IllegalStateException("Attempt to invoke wasCancelCalled from outside an ejb invocation");
    }

    @Override
    protected void checkAccessToCallerSecurity() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED) {
            throw new IllegalStateException("Operation not allowed");
        }
    }

    @Override
    public void checkTimerServiceMethodAccess() throws IllegalStateException {
        if (this.state == EJBContextImpl.BeanState.CREATED || this.inEjbRemove) {
            throw new IllegalStateException("EJB Timer method calls cannot be called in this context");
        }
    }

    protected ComponentInvocation getCurrentComponentInvocation() {
        BaseContainer container = (BaseContainer)this.getContainer();
        return container.invocationManager.getCurrentInvocation();
    }

    private boolean isWebServiceInvocation(ComponentInvocation inv) {
        return inv instanceof EjbInvocation && ((EjbInvocation)inv).isWebService;
    }
}

