/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.validation.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.server.validation.ValidationError;

@Provider
public class ValidationErrorMessageBodyWriter
implements MessageBodyWriter<Object> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupportedMediaType(mediaType) && this.isSupportedType(type, genericType);
    }

    private boolean isSupportedType(Class<?> type, Type genericType) {
        if (ValidationError.class.isAssignableFrom(type)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type) && genericType instanceof ParameterizedType) {
            return ValidationError.class.isAssignableFrom((Class)((ParameterizedType)genericType).getActualTypeArguments()[0]);
        }
        return false;
    }

    private boolean isSupportedMediaType(MediaType mediaType) {
        return MediaType.TEXT_HTML_TYPE.equals((Object)mediaType) || MediaType.TEXT_PLAIN_TYPE.equals((Object)mediaType);
    }

    public long getSize(Object validationErrors, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        List<ValidationError> errors = entity instanceof ValidationError ? Arrays.asList((ValidationError)entity) : (List<ValidationError>)entity;
        boolean isPlain = MediaType.TEXT_PLAIN_TYPE.getSubtype().equals(mediaType.getSubtype());
        StringBuilder builder = new StringBuilder();
        if (!isPlain) {
            builder.append("<div class=\"validation-errors\">");
        }
        for (ValidationError error : errors) {
            if (!isPlain) {
                builder.append("<div class=\"validation-error\">");
            }
            builder.append(isPlain ? error.getMessage() : "<span class=\"message\">" + error.getMessage() + "</span>");
            builder.append(' ');
            builder.append('(');
            builder.append(isPlain ? "path = " : "<span class=\"path\"><strong>path</strong> = ");
            builder.append(isPlain ? error.getPath() : error.getPath() + "</span>");
            builder.append(',');
            builder.append(' ');
            builder.append(isPlain ? "invalidValue = " : "<span class=\"invalid-value\"><strong>invalidValue</strong> = ");
            builder.append(isPlain ? error.getInvalidValue() : error.getInvalidValue() + "</span>");
            builder.append(')');
            if (!isPlain) {
                builder.append("</div>");
                continue;
            }
            builder.append('\n');
        }
        if (!isPlain) {
            builder.append("</div>");
        }
        entityStream.write(builder.toString().getBytes());
        entityStream.flush();
    }
}

